/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MimeType;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.spring.ForwardingClientHttpResponse;

final class Response
implements RawHttpResponse,
HttpResponse {
    private final ClientHttpResponse response;
    private byte[] body = new byte[0];

    Response(ClientHttpResponse response) {
        this.response = response;
    }

    public int getStatus() {
        try {
            return this.response.getRawStatusCode();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Multimap<String, String> getHeaders() {
        ArrayListMultimap map = ArrayListMultimap.create();
        this.response.getHeaders().forEach((arg_0, arg_1) -> ((ListMultimap)map).putAll(arg_0, arg_1));
        return map;
    }

    public String getContentType() {
        return Objects.toString(this.response.getHeaders().getContentType(), null);
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.response).map(HttpMessage::getHeaders).map(HttpHeaders::getContentType).map(MimeType::getCharSet).orElse(StandardCharsets.UTF_8);
    }

    public byte[] getBody() {
        return this.body;
    }

    public HttpResponse withBody() throws IOException {
        InputStream stream = this.response.getBody();
        if (stream != null) {
            this.body = ByteStreams.toByteArray((InputStream)stream);
        }
        return this;
    }

    ClientHttpResponse asClientHttpResponse() {
        return new ForwardingClientHttpResponse(){

            @Override
            protected ClientHttpResponse delegate() {
                return Response.this.response;
            }

            @Override
            public InputStream getBody() {
                return new ByteArrayInputStream(Response.this.body);
            }
        };
    }
}

