/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMessage;
import org.springframework.util.MimeType;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.spring.Localhost;

final class Request
implements RawHttpRequest,
HttpRequest {
    private final org.springframework.http.HttpRequest request;
    private final byte[] body;
    private final Localhost localhost;

    Request(org.springframework.http.HttpRequest request, byte[] body, Localhost localhost) {
        this.request = request;
        this.body = body;
        this.localhost = localhost;
    }

    public String getRemote() {
        try {
            return this.localhost.getAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getMethod() {
        return this.request.getMethod().name();
    }

    public URI getRequestUri() {
        return this.request.getURI();
    }

    public Multimap<String, String> getHeaders() {
        ArrayListMultimap map = ArrayListMultimap.create();
        this.request.getHeaders().forEach((arg_0, arg_1) -> ((ListMultimap)map).putAll(arg_0, arg_1));
        return map;
    }

    public String getContentType() {
        return Objects.toString(this.request.getHeaders().getContentType(), null);
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.request).map(HttpMessage::getHeaders).map(HttpHeaders::getContentType).map(MimeType::getCharSet).orElse(StandardCharsets.UTF_8);
    }

    public byte[] getBody() {
        return this.body;
    }

    public HttpRequest withBody() {
        return this;
    }
}

