/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Optional;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.zalando.logbook.Correlator;
import org.zalando.logbook.Logbook;
import org.zalando.logbook.RawHttpRequest;
import org.zalando.logbook.RawHttpResponse;
import org.zalando.logbook.spring.Localhost;
import org.zalando.logbook.spring.Request;
import org.zalando.logbook.spring.Response;

public final class LogbookClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final Logbook logbook;
    private final Localhost localhost;

    public LogbookClientHttpRequestInterceptor(Logbook logbook) {
        this(logbook, Localhost.resolve());
    }

    @VisibleForTesting
    LogbookClientHttpRequestInterceptor(Logbook logbook, Localhost localhost) {
        this.logbook = logbook;
        this.localhost = localhost;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        Optional correlator = this.logbook.write((RawHttpRequest)new Request(request, body, this.localhost));
        ClientHttpResponse original = execution.execute(request, body);
        if (correlator.isPresent()) {
            Response response = new Response(original);
            ((Correlator)correlator.get()).write((RawHttpResponse)response);
            return response.asClientHttpResponse();
        }
        return original;
    }
}

