/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.zalando.logbook.api.HttpHeaders;
import org.zalando.logbook.api.Origin;

final class LocalRequest
implements org.zalando.logbook.api.HttpRequest {
    private final HttpRequest request;
    private final byte[] body;
    private boolean withBody = false;

    public String getRemote() {
        return "localhost";
    }

    public String getMethod() {
        return this.request.getMethod().name();
    }

    public String getScheme() {
        return Optional.of(this.request.getURI()).map(URI::getScheme).orElse("");
    }

    public String getHost() {
        return Optional.of(this.request.getURI()).map(URI::getHost).orElse("");
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.request.getURI().getPort()).filter(p -> p != -1);
    }

    public String getPath() {
        return Optional.of(this.request.getURI()).map(URI::getPath).orElse("");
    }

    public String getQuery() {
        return Optional.of(this.request.getURI()).map(URI::getQuery).orElse("");
    }

    public org.zalando.logbook.api.HttpRequest withBody() throws IOException {
        this.withBody = true;
        return this;
    }

    public org.zalando.logbook.api.HttpRequest withoutBody() {
        this.withBody = false;
        return this;
    }

    public String getProtocolVersion() {
        return "HTTP/1.1";
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.request.getHeaders());
    }

    @Nullable
    public String getContentType() {
        return Optional.ofNullable(this.request.getHeaders().getFirst("Content-Type")).orElse(null);
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.getContentType()).map(ct -> MediaType.parseMediaType((String)ct).getCharset()).orElse(StandardCharsets.UTF_8);
    }

    public byte[] getBody() throws IOException {
        return this.withBody ? this.body : new byte[]{};
    }

    @Generated
    public LocalRequest(HttpRequest request, byte[] body) {
        this.request = request;
        this.body = body;
    }
}

