/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.MockHttpMessage;
import org.zalando.logbook.Origin;

@Immutable
public final class MockHttpResponse
implements MockHttpMessage,
HttpResponse {
    private final String protocolVersion;
    private final Origin origin;
    private final int status;
    private final Map<String, List<String>> headers;
    private final String contentType;
    private final Charset charset;
    private final String body;

    public MockHttpResponse(@Nullable String protocolVersion, @Nullable Origin origin, int status, @Nullable Map<String, List<String>> headers, @Nullable String contentType, @Nullable Charset charset, @Nullable String body) {
        this.protocolVersion = Optional.ofNullable(protocolVersion).orElse("HTTP/1.1");
        this.origin = Optional.ofNullable(origin).orElse(Origin.LOCAL);
        this.status = status == 0 ? 200 : status;
        this.headers = this.firstNonNullNorEmpty(headers, Collections.emptyMap());
        this.contentType = Optional.ofNullable(contentType).orElse("");
        this.charset = Optional.ofNullable(charset).orElse(StandardCharsets.UTF_8);
        this.body = Optional.ofNullable(body).orElse("");
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public byte[] getBody() {
        return this.getBodyAsString().getBytes(this.getCharset());
    }

    public String getBodyAsString() {
        return this.body;
    }

    static HttpResponse create() {
        return MockHttpResponse.response().build();
    }

    public static Builder response() {
        return new Builder();
    }

    public static class Builder {
        private String protocolVersion;
        private Origin origin;
        private int status;
        private Map<String, List<String>> headers;
        private String contentType;
        private Charset charset;
        private String body;

        Builder() {
        }

        public Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder origin(Origin origin) {
            this.origin = origin;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public MockHttpResponse build() {
            return new MockHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, this.contentType, this.charset, this.body);
        }

        public String toString() {
            return "MockHttpResponse.Builder(protocolVersion=" + this.protocolVersion + ", origin=" + this.origin + ", status=" + this.status + ", headers=" + this.headers + ", contentType=" + this.contentType + ", charset=" + this.charset + ", body=" + this.body + ")";
        }
    }
}

