/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.MockHttpMessage;
import org.zalando.logbook.MockHttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.RawHttpRequest;

@Immutable
public final class MockRawHttpRequest
implements MockHttpMessage,
RawHttpRequest {
    private final String protocolVersion;
    private final Origin origin;
    private final String remote;
    private final String method;
    private final String scheme;
    private final String host;
    private final int port;
    private final String path;
    private final String query;
    private final Map<String, List<String>> headers;
    private final String contentType;
    private final Charset charset;
    private final String body;

    public MockRawHttpRequest(@Nullable String protocolVersion, @Nullable Origin origin, @Nullable String remote, @Nullable String method, @Nullable String scheme, @Nullable String host, int port, @Nullable String path, @Nullable String query, @Nullable Map<String, List<String>> headers, @Nullable String contentType, @Nullable Charset charset, @Nullable String body) {
        this.protocolVersion = Optional.ofNullable(protocolVersion).orElse("HTTP/1.1");
        this.origin = Optional.ofNullable(origin).orElse(Origin.REMOTE);
        this.remote = Optional.ofNullable(remote).orElse("127.0.0.1");
        this.method = Optional.ofNullable(method).orElse("GET");
        this.scheme = Optional.ofNullable(scheme).orElse("http");
        this.host = Optional.ofNullable(host).orElse("localhost");
        this.port = port == 0 ? 80 : port;
        this.path = Optional.ofNullable(path).orElse("/");
        this.query = Optional.ofNullable(query).orElse("");
        this.headers = this.firstNonNullNorEmpty(headers, Collections.emptyMap());
        this.contentType = Optional.ofNullable(contentType).orElse("");
        this.charset = Optional.ofNullable(charset).orElse(StandardCharsets.UTF_8);
        this.body = Optional.ofNullable(body).orElse("");
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getMethod() {
        return this.method;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public HttpRequest withBody() throws IOException {
        return MockHttpRequest.request().protocolVersion(this.protocolVersion).origin(this.origin).remote(this.remote).method(this.method).scheme(this.scheme).host(this.host).port(this.port).path(this.path).query(this.query).headers(this.headers).contentType(this.contentType).charset(this.charset).body(this.body).build();
    }

    public static RawHttpRequest create() {
        return MockRawHttpRequest.request().build();
    }

    public static Builder request() {
        return new Builder();
    }

    public static class Builder {
        private String protocolVersion;
        private Origin origin;
        private String remote;
        private String method;
        private String scheme;
        private String host;
        private int port;
        private String path;
        private String query;
        private Map<String, List<String>> headers;
        private String contentType;
        private Charset charset;
        private String body;

        Builder() {
        }

        public Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder origin(Origin origin) {
            this.origin = origin;
            return this;
        }

        public Builder remote(String remote) {
            this.remote = remote;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public MockRawHttpRequest build() {
            return new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.body);
        }

        public String toString() {
            return "MockRawHttpRequest.Builder(protocolVersion=" + this.protocolVersion + ", origin=" + this.origin + ", remote=" + this.remote + ", method=" + this.method + ", scheme=" + this.scheme + ", host=" + this.host + ", port=" + this.port + ", path=" + this.path + ", query=" + this.query + ", headers=" + this.headers + ", contentType=" + this.contentType + ", charset=" + this.charset + ", body=" + this.body + ")";
        }
    }
}

