/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.zalando.logbook.MockHttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.RawHttpResponse;

@API(status=API.Status.MAINTAINED)
public final class MockRawHttpResponse
implements RawHttpResponse {
    private String protocolVersion = "HTTP/1.1";
    private Origin origin = Origin.LOCAL;
    private int status = 200;
    private Map<String, List<String>> headers = Collections.emptyMap();
    private String contentType = "text/plain";
    private Charset charset = StandardCharsets.UTF_8;
    private String bodyAsString = "";

    public MockHttpResponse withBody() throws IOException {
        return MockHttpResponse.create().withProtocolVersion(this.protocolVersion).withOrigin(this.origin).withStatus(this.status).withHeaders(this.headers).withContentType(this.contentType).withCharset(this.charset).withBodyAsString(this.bodyAsString);
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getBodyAsString() {
        return this.bodyAsString;
    }

    public MockRawHttpResponse withProtocolVersion(String protocolVersion) {
        return this.protocolVersion == protocolVersion ? this : new MockRawHttpResponse(protocolVersion, this.origin, this.status, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpResponse withOrigin(Origin origin) {
        return this.origin == origin ? this : new MockRawHttpResponse(this.protocolVersion, origin, this.status, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpResponse withStatus(int status) {
        return this.status == status ? this : new MockRawHttpResponse(this.protocolVersion, this.origin, status, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpResponse withHeaders(Map<String, List<String>> headers) {
        return this.headers == headers ? this : new MockRawHttpResponse(this.protocolVersion, this.origin, this.status, headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpResponse withContentType(String contentType) {
        return this.contentType == contentType ? this : new MockRawHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpResponse withCharset(Charset charset) {
        return this.charset == charset ? this : new MockRawHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, this.contentType, charset, this.bodyAsString);
    }

    public MockRawHttpResponse withBodyAsString(String bodyAsString) {
        return this.bodyAsString == bodyAsString ? this : new MockRawHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, this.contentType, this.charset, bodyAsString);
    }

    private MockRawHttpResponse() {
    }

    public static MockRawHttpResponse create() {
        return new MockRawHttpResponse();
    }

    public MockRawHttpResponse(String protocolVersion, Origin origin, int status, Map<String, List<String>> headers, String contentType, Charset charset, String bodyAsString) {
        this.protocolVersion = protocolVersion;
        this.origin = origin;
        this.status = status;
        this.headers = headers;
        this.contentType = contentType;
        this.charset = charset;
        this.bodyAsString = bodyAsString;
    }
}

