/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;

@API(status=API.Status.MAINTAINED)
public final class MockHttpRequest
implements HttpRequest {
    private String protocolVersion = "HTTP/1.1";
    private Origin origin = Origin.REMOTE;
    private String remote = "127.0.0.1";
    private String method = "GET";
    private String scheme = "http";
    private String host = "localhost";
    private Optional<Integer> port = Optional.of(80);
    private String path = "/";
    private String query = "";
    private Map<String, List<String>> headers = Collections.emptyMap();
    private String contentType = "text/plain";
    private Charset charset = StandardCharsets.UTF_8;
    private String bodyAsString = "";

    public byte[] getBody() {
        return this.bodyAsString.getBytes(StandardCharsets.UTF_8);
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getMethod() {
        return this.method;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public Optional<Integer> getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getBodyAsString() {
        return this.bodyAsString;
    }

    public MockHttpRequest withProtocolVersion(String protocolVersion) {
        return this.protocolVersion == protocolVersion ? this : new MockHttpRequest(protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withOrigin(Origin origin) {
        return this.origin == origin ? this : new MockHttpRequest(this.protocolVersion, origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withRemote(String remote) {
        return this.remote == remote ? this : new MockHttpRequest(this.protocolVersion, this.origin, remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withMethod(String method) {
        return this.method == method ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withScheme(String scheme) {
        return this.scheme == scheme ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withHost(String host) {
        return this.host == host ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withPort(Optional<Integer> port) {
        return this.port == port ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withPath(String path) {
        return this.path == path ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withQuery(String query) {
        return this.query == query ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withHeaders(Map<String, List<String>> headers) {
        return this.headers == headers ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withContentType(String contentType) {
        return this.contentType == contentType ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, contentType, this.charset, this.bodyAsString);
    }

    public MockHttpRequest withCharset(Charset charset) {
        return this.charset == charset ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, charset, this.bodyAsString);
    }

    public MockHttpRequest withBodyAsString(String bodyAsString) {
        return this.bodyAsString == bodyAsString ? this : new MockHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, bodyAsString);
    }

    private MockHttpRequest() {
    }

    public static MockHttpRequest create() {
        return new MockHttpRequest();
    }

    public MockHttpRequest(String protocolVersion, Origin origin, String remote, String method, String scheme, String host, Optional<Integer> port, String path, String query, Map<String, List<String>> headers, String contentType, Charset charset, String bodyAsString) {
        this.protocolVersion = protocolVersion;
        this.origin = origin;
        this.remote = remote;
        this.method = method;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.contentType = contentType;
        this.charset = charset;
        this.bodyAsString = bodyAsString;
    }
}

