/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apiguardian.api.API;
import org.zalando.logbook.MockHttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.RawHttpRequest;

@API(status=API.Status.MAINTAINED)
public final class MockRawHttpRequest
implements RawHttpRequest {
    private String protocolVersion = "HTTP/1.1";
    private Origin origin = Origin.REMOTE;
    private String remote = "127.0.0.1";
    private String method = "GET";
    private String scheme = "http";
    private String host = "localhost";
    private Optional<Integer> port = Optional.of(80);
    private String path = "/";
    private String query = "";
    private Map<String, List<String>> headers = Collections.emptyMap();
    private String contentType = "text/plain";
    private Charset charset = StandardCharsets.UTF_8;
    private String bodyAsString = "";

    public MockHttpRequest withBody() throws IOException {
        return MockHttpRequest.create().withProtocolVersion(this.protocolVersion).withOrigin(this.origin).withRemote(this.remote).withMethod(this.method).withScheme(this.scheme).withHost(this.host).withPort(this.port).withPath(this.path).withQuery(this.query).withHeaders(this.headers).withContentType(this.contentType).withCharset(this.charset).withBodyAsString(this.bodyAsString);
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getMethod() {
        return this.method;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public Optional<Integer> getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getBodyAsString() {
        return this.bodyAsString;
    }

    public MockRawHttpRequest withProtocolVersion(String protocolVersion) {
        return this.protocolVersion == protocolVersion ? this : new MockRawHttpRequest(protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withOrigin(Origin origin) {
        return this.origin == origin ? this : new MockRawHttpRequest(this.protocolVersion, origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withRemote(String remote) {
        return this.remote == remote ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withMethod(String method) {
        return this.method == method ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withScheme(String scheme) {
        return this.scheme == scheme ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withHost(String host) {
        return this.host == host ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withPort(Optional<Integer> port) {
        return this.port == port ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, port, this.path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withPath(String path) {
        return this.path == path ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, path, this.query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withQuery(String query) {
        return this.query == query ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, query, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withHeaders(Map<String, List<String>> headers) {
        return this.headers == headers ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withContentType(String contentType) {
        return this.contentType == contentType ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, contentType, this.charset, this.bodyAsString);
    }

    public MockRawHttpRequest withCharset(Charset charset) {
        return this.charset == charset ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, charset, this.bodyAsString);
    }

    public MockRawHttpRequest withBodyAsString(String bodyAsString) {
        return this.bodyAsString == bodyAsString ? this : new MockRawHttpRequest(this.protocolVersion, this.origin, this.remote, this.method, this.scheme, this.host, this.port, this.path, this.query, this.headers, this.contentType, this.charset, bodyAsString);
    }

    private MockRawHttpRequest() {
    }

    public static MockRawHttpRequest create() {
        return new MockRawHttpRequest();
    }

    public MockRawHttpRequest(String protocolVersion, Origin origin, String remote, String method, String scheme, String host, Optional<Integer> port, String path, String query, Map<String, List<String>> headers, String contentType, Charset charset, String bodyAsString) {
        this.protocolVersion = protocolVersion;
        this.origin = origin;
        this.remote = remote;
        this.method = method;
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.contentType = contentType;
        this.charset = charset;
        this.bodyAsString = bodyAsString;
    }
}

