/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook;

import java.beans.ConstructorProperties;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;

public final class MockHttpResponse
implements HttpResponse {
    private String protocolVersion = "HTTP/1.1";
    private Origin origin = Origin.LOCAL;
    private int status = 200;
    private Map<String, List<String>> headers = Collections.emptyMap();
    private String contentType = "text/plain";
    private Charset charset = StandardCharsets.UTF_8;
    private String bodyAsString = "";

    public byte[] getBody() {
        return this.bodyAsString.getBytes(StandardCharsets.UTF_8);
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getBodyAsString() {
        return this.bodyAsString;
    }

    public MockHttpResponse withProtocolVersion(String protocolVersion) {
        return this.protocolVersion == protocolVersion ? this : new MockHttpResponse(protocolVersion, this.origin, this.status, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpResponse withOrigin(Origin origin) {
        return this.origin == origin ? this : new MockHttpResponse(this.protocolVersion, origin, this.status, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpResponse withStatus(int status) {
        return this.status == status ? this : new MockHttpResponse(this.protocolVersion, this.origin, status, this.headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpResponse withHeaders(Map<String, List<String>> headers) {
        return this.headers == headers ? this : new MockHttpResponse(this.protocolVersion, this.origin, this.status, headers, this.contentType, this.charset, this.bodyAsString);
    }

    public MockHttpResponse withContentType(String contentType) {
        return this.contentType == contentType ? this : new MockHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, contentType, this.charset, this.bodyAsString);
    }

    public MockHttpResponse withCharset(Charset charset) {
        return this.charset == charset ? this : new MockHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, this.contentType, charset, this.bodyAsString);
    }

    public MockHttpResponse withBodyAsString(String bodyAsString) {
        return this.bodyAsString == bodyAsString ? this : new MockHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, this.contentType, this.charset, bodyAsString);
    }

    private MockHttpResponse() {
    }

    public static MockHttpResponse create() {
        return new MockHttpResponse();
    }

    @ConstructorProperties(value={"protocolVersion", "origin", "status", "headers", "contentType", "charset", "bodyAsString"})
    private MockHttpResponse(String protocolVersion, Origin origin, int status, Map<String, List<String>> headers, String contentType, Charset charset, String bodyAsString) {
        this.protocolVersion = protocolVersion;
        this.origin = origin;
        this.status = status;
        this.headers = headers;
        this.contentType = contentType;
        this.charset = charset;
        this.bodyAsString = bodyAsString;
    }
}

