/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.test;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apiguardian.api.API;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;
import org.zalando.logbook.attributes.HttpAttributes;

@API(status=API.Status.MAINTAINED)
public final class MockHttpResponse
implements HttpResponse {
    private String protocolVersion = "HTTP/1.1";
    private Origin origin = Origin.LOCAL;
    private int status = 200;
    private HttpHeaders headers = HttpHeaders.empty();
    private String contentType = "text/plain";
    private Charset charset = StandardCharsets.UTF_8;
    private String bodyAsString = "";
    private HttpAttributes httpAttributes = HttpAttributes.EMPTY;

    public byte[] getBody() {
        return this.bodyAsString.getBytes(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() {
        return this;
    }

    public HttpResponse withoutBody() {
        this.bodyAsString = "";
        return this;
    }

    public HttpAttributes getAttributes() {
        return this.httpAttributes;
    }

    @Generated
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Generated
    public Origin getOrigin() {
        return this.origin;
    }

    @Generated
    public int getStatus() {
        return this.status;
    }

    @Generated
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Generated
    public String getContentType() {
        return this.contentType;
    }

    @Generated
    public Charset getCharset() {
        return this.charset;
    }

    @Generated
    public String getBodyAsString() {
        return this.bodyAsString;
    }

    @Generated
    public HttpAttributes getHttpAttributes() {
        return this.httpAttributes;
    }

    @Generated
    public MockHttpResponse withProtocolVersion(String protocolVersion) {
        return this.protocolVersion == protocolVersion ? this : new MockHttpResponse(protocolVersion, this.origin, this.status, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpResponse withOrigin(Origin origin) {
        return this.origin == origin ? this : new MockHttpResponse(this.protocolVersion, origin, this.status, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpResponse withStatus(int status) {
        return this.status == status ? this : new MockHttpResponse(this.protocolVersion, this.origin, status, this.headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpResponse withHeaders(HttpHeaders headers) {
        return this.headers == headers ? this : new MockHttpResponse(this.protocolVersion, this.origin, this.status, headers, this.contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpResponse withContentType(String contentType) {
        return this.contentType == contentType ? this : new MockHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, contentType, this.charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpResponse withCharset(Charset charset) {
        return this.charset == charset ? this : new MockHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, this.contentType, charset, this.bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpResponse withBodyAsString(String bodyAsString) {
        return this.bodyAsString == bodyAsString ? this : new MockHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, this.contentType, this.charset, bodyAsString, this.httpAttributes);
    }

    @Generated
    public MockHttpResponse withHttpAttributes(HttpAttributes httpAttributes) {
        return this.httpAttributes == httpAttributes ? this : new MockHttpResponse(this.protocolVersion, this.origin, this.status, this.headers, this.contentType, this.charset, this.bodyAsString, httpAttributes);
    }

    @Generated
    private MockHttpResponse() {
    }

    @Generated
    public static MockHttpResponse create() {
        return new MockHttpResponse();
    }

    @Generated
    private MockHttpResponse(String protocolVersion, Origin origin, int status, HttpHeaders headers, String contentType, Charset charset, String bodyAsString, HttpAttributes httpAttributes) {
        this.protocolVersion = protocolVersion;
        this.origin = origin;
        this.status = status;
        this.headers = headers;
        this.contentType = contentType;
        this.charset = charset;
        this.bodyAsString = bodyAsString;
        this.httpAttributes = httpAttributes;
    }
}

