/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.maven.plugins.kio;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.zalando.stups.clients.kio.CreateOrUpdateVersionRequest;

@Mojo(name="updateVersion", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class UpdateVersionMojo
extends AbstractMojo {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String BEARER = "Bearer: ";
    private static final String AUTHORIZATION = "Authorization";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    @Parameter(defaultValue="${project.version}", required=true)
    protected String versionId;
    @Parameter(required=true)
    protected String applicationId;
    @Parameter(required=true)
    protected String artifact;
    @Parameter(defaultValue="kio-maven-plugin")
    protected String notes = "kio-maven-plugin";
    @Parameter(required=true)
    protected String kioBaseUrl;
    @Parameter(required=false, defaultValue="false")
    protected boolean skip = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"PLUGIN WAS SET TO SKIP, CHECK POM.XML");
            return;
        }
        CreateOrUpdateVersionRequest r = this.buildRequestObject();
        this.executeRequest(r);
    }

    protected CreateOrUpdateVersionRequest buildRequestObject() {
        CreateOrUpdateVersionRequest r = new CreateOrUpdateVersionRequest();
        r.setArtifact(this.artifact);
        r.setNotes(this.notes);
        return r;
    }

    protected void executeRequest(CreateOrUpdateVersionRequest r) throws MojoExecutionException {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
        try {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)this.buildBodyContent(r));
            Request request = new Request.Builder().url(this.buildUrl()).put(body).addHeader(AUTHORIZATION, BEARER + this.getToken()).build();
            try (Response response = client.newCall(request).execute();){
                String result = response.body().string();
                this.getLog().info((CharSequence)result);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected String buildBodyContent(CreateOrUpdateVersionRequest r) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)r);
    }

    protected String buildUrl() {
        return this.kioBaseUrl + "/apps/" + this.applicationId + "/versions/" + this.versionId;
    }

    protected String getToken() throws JsonProcessingException, IOException {
        String os = System.getProperty("os.name");
        String applicationSupportDirectory = null;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        applicationSupportDirectory = os.startsWith("Mac OS") ? System.getProperty("user.home") + "/Library/Application Support/zign" : System.getProperty("user.home") + "/.config/zign";
        Map map = (Map)mapper.readValue(new File(applicationSupportDirectory, "tokens.yaml"), Map.class);
        LinkedHashMap json = (LinkedHashMap)map.get("kio");
        if (json == null) {
            this.getLog().error((CharSequence)"no token found for 'kio', run 'zign token kio' before.");
            throw new IOException("No Token found for 'kio'");
        }
        return (String)json.get(ACCESS_TOKEN);
    }
}

