/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.maven.plugins.swagger.codegen;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.zalando.maven.plugins.swagger.codegen.MojoCodegeneratorLogger;
import org.zalando.stups.swagger.codegen.CodegenerationException;
import org.zalando.stups.swagger.codegen.CodegeneratorLogger;
import org.zalando.stups.swagger.codegen.StandaloneCodegenerator;

@Mojo(name="codegen", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CodegenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources/java")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/swagger.yaml")
    private String apiFile;
    @Parameter(required=true)
    private String language;
    @Parameter(required=true)
    private String apiPackage;
    @Parameter
    private String modelPackage;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StandaloneCodegenerator generator = StandaloneCodegenerator.builder().withApiFilePath(this.apiFile).forLanguage(this.language).writeResultsTo(this.outputDirectory).withApiPackage(this.apiPackage).withModelPackage(this.modelPackage).withLogger((CodegeneratorLogger)new MojoCodegeneratorLogger(this.getLog())).build();
        try {
            generator.generate();
            this.project.addCompileSourceRoot(generator.getOutputDirectoryPath());
        }
        catch (CodegenerationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

