/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.maven.plugins.swagger.codegen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.util.Yaml;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.zalando.maven.plugins.swagger.codegen.MojoCodegeneratorLogger;
import org.zalando.stups.swagger.codegen.CodegenerationException;
import org.zalando.stups.swagger.codegen.CodegeneratorLogger;
import org.zalando.stups.swagger.codegen.StandaloneCodegenerator;

@Mojo(name="codegen", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CodegenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources/java")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/swagger.yaml")
    private String apiFile;
    @Parameter(required=true)
    private String language;
    @Parameter
    private String apiPackage;
    @Parameter
    private String modelPackage;
    @Parameter
    private boolean yamlToJson = false;
    @Parameter(required=true, defaultValue="${project.build.directory}/classes")
    private File yamlToJsonOutputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block7: {
            StandaloneCodegenerator generator = StandaloneCodegenerator.builder().withApiFilePath(this.apiFile).forLanguage(this.language).writeResultsTo(this.outputDirectory).withApiPackage(this.apiPackage).withModelPackage(this.modelPackage).withLogger((CodegeneratorLogger)new MojoCodegeneratorLogger(this.getLog())).build();
            try {
                generator.generate();
                this.project.addCompileSourceRoot(generator.getOutputDirectoryPath());
                if (!this.yamlToJson) break block7;
                this.getLog().info((CharSequence)"Generate .json file from .yaml");
                if (!this.yamlToJsonOutputDirectory.exists()) {
                    this.yamlToJsonOutputDirectory.mkdirs();
                    this.getLog().info((CharSequence)"OutputDirectory created");
                }
                File jsonFile = new File(this.yamlToJsonOutputDirectory, this.getYamlFilename() + ".json");
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(jsonFile);
                    fileWriter.write(this.getYamlFileContentAsJson());
                    fileWriter.flush();
                    this.getLog().info((CharSequence)("File written to " + jsonFile.getAbsolutePath()));
                }
                catch (Exception e) {
                    try {
                        throw new MojoExecutionException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileWriter);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)fileWriter);
            }
            catch (CodegenerationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    protected String getYamlFileContentAsJson() throws IOException {
        String data = new String(Files.readAllBytes(Paths.get(new File(this.apiFile).toURI())));
        ObjectMapper yamlMapper = Yaml.mapper();
        JsonNode rootNode = yamlMapper.readTree(data);
        JsonNode swaggerNode = rootNode.get("swagger");
        return rootNode.toString();
    }

    protected String getYamlFilename() throws MojoExecutionException {
        File file = new File(this.apiFile);
        if (!file.exists()) {
            throw new MojoExecutionException("Api-File not found: " + this.apiFile);
        }
        String filename = file.getName();
        return filename.substring(0, filename.indexOf("."));
    }
}

