/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.money.validation;

import java.math.BigDecimal;
import javax.money.MonetaryAmount;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMax;

public class MonetaryAmountDecimalMaxValidator
implements ConstraintValidator<DecimalMax, MonetaryAmount> {
    private BigDecimal maxValue;
    private boolean inclusive;

    public void initialize(DecimalMax annotation) {
        this.maxValue = new BigDecimal(annotation.value());
        this.inclusive = annotation.inclusive();
    }

    public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        BigDecimal amount = (BigDecimal)value.getNumber().numberValueExact(BigDecimal.class);
        int comparisonResult = amount.compareTo(this.maxValue);
        return this.inclusive ? comparisonResult <= 0 : comparisonResult < 0;
    }
}

