/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.zalando.fahrschein.NakadiClient;
import org.zalando.nakadiproducer.AccessTokenProvider;
import org.zalando.nakadiproducer.FlywayMigrator;
import org.zalando.nakadiproducer.StupsTokenComponent;
import org.zalando.nakadiproducer.eventlog.EventLogWriter;
import org.zalando.nakadiproducer.eventlog.impl.EventLogRepository;
import org.zalando.nakadiproducer.eventlog.impl.EventLogRepositoryImpl;
import org.zalando.nakadiproducer.eventlog.impl.EventLogWriterImpl;
import org.zalando.nakadiproducer.flowid.FlowIdComponent;
import org.zalando.nakadiproducer.flowid.NoopFlowIdComponent;
import org.zalando.nakadiproducer.flowid.TracerFlowIdComponent;
import org.zalando.nakadiproducer.snapshots.SimpleSnapshotEventGenerator;
import org.zalando.nakadiproducer.snapshots.Snapshot;
import org.zalando.nakadiproducer.snapshots.SnapshotEventGenerator;
import org.zalando.nakadiproducer.snapshots.SnapshotEventProvider;
import org.zalando.nakadiproducer.snapshots.impl.SnapshotCreationService;
import org.zalando.nakadiproducer.snapshots.impl.SnapshotEventCreationEndpoint;
import org.zalando.nakadiproducer.snapshots.impl.SnapshotEventCreationMvcEndpoint;
import org.zalando.nakadiproducer.transmission.NakadiPublishingClient;
import org.zalando.nakadiproducer.transmission.impl.EventTransmissionService;
import org.zalando.nakadiproducer.transmission.impl.EventTransmitter;
import org.zalando.nakadiproducer.transmission.impl.FahrscheinNakadiPublishingClient;
import org.zalando.tracer.Tracer;

@Configuration
@ComponentScan
@AutoConfigureAfter(name={"org.zalando.tracer.spring.TracerAutoConfiguration"})
public class NakadiProducerAutoConfiguration {
    @Bean
    @ConditionalOnMissingClass(value={"org.zalando.tracer.Tracer"})
    @ConditionalOnMissingBean(value={FlowIdComponent.class})
    public FlowIdComponent flowIdComponent() {
        return new NoopFlowIdComponent();
    }

    @Bean
    public SnapshotCreationService snapshotCreationService(Optional<List<SnapshotEventGenerator>> snapshotEventGenerators, Optional<SnapshotEventProvider> snapshotEventProvider, EventLogWriter eventLogWriter) {
        Stream legacyGenerators = snapshotEventProvider.map(this::wrapInSnapshotEventGenerators).orElseGet(Stream::empty);
        Stream nonLegacyGenerators = snapshotEventGenerators.map(Collection::stream).orElseGet(Stream::empty);
        List allGenerators = Stream.concat(legacyGenerators, nonLegacyGenerators).collect(Collectors.toList());
        return new SnapshotCreationService(allGenerators, eventLogWriter);
    }

    private Stream<SnapshotEventGenerator> wrapInSnapshotEventGenerators(SnapshotEventProvider p) {
        return p.getSupportedEventTypes().stream().map(t -> this.wrapInSnapshotEventGenerator(p, (String)t));
    }

    private SnapshotEventGenerator wrapInSnapshotEventGenerator(SnapshotEventProvider provider, String eventType) {
        return new SimpleSnapshotEventGenerator(eventType, cursor -> this.createNonLegacySnapshots(provider, eventType, cursor));
    }

    private List<Snapshot> createNonLegacySnapshots(SnapshotEventProvider provider, String eventType, Object cursor) {
        return provider.getSnapshot(eventType, cursor).stream().map(this::mapLegacyToNewSnapshot).collect(Collectors.toList());
    }

    private Snapshot mapLegacyToNewSnapshot(SnapshotEventProvider.Snapshot snapshot) {
        return new Snapshot(snapshot.getId(), snapshot.getDataType(), snapshot.getData());
    }

    @Bean
    public EventLogWriter eventLogWriter(EventLogRepository eventLogRepository, ObjectMapper objectMapper, FlowIdComponent flowIdComponent) {
        return new EventLogWriterImpl(eventLogRepository, objectMapper, flowIdComponent);
    }

    @Bean
    public EventLogRepository eventLogRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        return new EventLogRepositoryImpl(namedParameterJdbcTemplate);
    }

    @Bean
    public EventTransmitter eventTransmitter(EventTransmissionService eventTransmissionService) {
        return new EventTransmitter(eventTransmissionService);
    }

    @Bean
    public EventTransmissionService eventTransmissionService(EventLogRepository eventLogRepository, NakadiPublishingClient nakadiPublishingClient, ObjectMapper objectMapper) {
        return new EventTransmissionService(eventLogRepository, nakadiPublishingClient, objectMapper);
    }

    @Bean
    public FlywayMigrator flywayMigrator() {
        return new FlywayMigrator();
    }

    @ManagementContextConfiguration
    static class ManagementEndpointConfiguration {
        ManagementEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SnapshotEventCreationEndpoint snapshotEventCreationEndpoint(SnapshotCreationService snapshotCreationService) {
            return new SnapshotEventCreationEndpoint(snapshotCreationService);
        }

        @Bean
        @ConditionalOnBean(value={SnapshotEventCreationEndpoint.class})
        @ConditionalOnEnabledEndpoint(value="snapshot_event_creation")
        public SnapshotEventCreationMvcEndpoint snapshotEventCreationMvcEndpoint(SnapshotEventCreationEndpoint snapshotEventCreationEndpoint) {
            return new SnapshotEventCreationMvcEndpoint(snapshotEventCreationEndpoint);
        }
    }

    @ConditionalOnClass(name={"org.zalando.tracer.Tracer"})
    @Configuration
    static class TracerConfiguration {
        @Autowired(required=false)
        Tracer tracer;

        TracerConfiguration() {
        }

        @ConditionalOnMissingBean(value={FlowIdComponent.class})
        @Bean
        public FlowIdComponent flowIdComponent() {
            if (this.tracer == null) {
                return new NoopFlowIdComponent();
            }
            return new TracerFlowIdComponent(this.tracer);
        }
    }

    @ConditionalOnMissingBean(value={NakadiPublishingClient.class})
    @Configuration
    @Import(value={StupsTokenConfiguration.class})
    static class FahrscheinNakadiClientConfiguration {
        FahrscheinNakadiClientConfiguration() {
        }

        @Bean
        public NakadiPublishingClient nakadiClient(AccessTokenProvider accessTokenProvider, @Value(value="${nakadi-producer.nakadi-base-uri}") URI nakadiBaseUri) {
            return new FahrscheinNakadiPublishingClient(NakadiClient.builder((URI)nakadiBaseUri).withAccessTokenProvider(accessTokenProvider::getAccessToken).build());
        }

        @ConditionalOnClass(name={"org.zalando.stups.tokens.Tokens"})
        @Configuration
        static class StupsTokenConfiguration {
            StupsTokenConfiguration() {
            }

            @Bean(destroyMethod="stop")
            @ConditionalOnProperty(value={"nakadi-producer.access-token-uri", "nakadi-producer.access-token-scopes"})
            @ConditionalOnMissingBean(value={AccessTokenProvider.class})
            public StupsTokenComponent accessTokenProvider(@Value(value="${nakadi-producer.access-token-uri}") URI accessTokenUri, @Value(value="${nakadi-producer.access-token-scopes}") String[] accessTokenScopes) {
                return new StupsTokenComponent(accessTokenUri, Arrays.asList(accessTokenScopes));
            }
        }
    }
}

