/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.snapshots.impl;

import java.beans.ConstructorProperties;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.zalando.nakadiproducer.snapshots.impl.SnapshotCreationService;

@ConfigurationProperties(value="endpoints.snapshot-event-creation")
public class SnapshotEventCreationEndpoint
extends AbstractEndpoint<SnapshotReport> {
    private final SnapshotCreationService snapshotCreationService;

    public SnapshotEventCreationEndpoint(SnapshotCreationService snapshotCreationService) {
        super("snapshot_event_creation", true, true);
        this.snapshotCreationService = snapshotCreationService;
    }

    public SnapshotReport invoke() {
        return new SnapshotReport(this.snapshotCreationService.getSupportedEventTypes());
    }

    public void invoke(String eventType, String filter) {
        this.snapshotCreationService.createSnapshotEvents(eventType, filter);
    }

    public static class SnapshotReport {
        private final Set<String> supportedEventTypes;

        @ConstructorProperties(value={"supportedEventTypes"})
        public SnapshotReport(Set<String> supportedEventTypes) {
            this.supportedEventTypes = supportedEventTypes;
        }

        public Set<String> getSupportedEventTypes() {
            return this.supportedEventTypes;
        }
    }
}

