/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.eventlog.impl;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.zalando.nakadiproducer.eventlog.impl.EventLog;
import org.zalando.nakadiproducer.eventlog.impl.EventLogRepository;

public class EventLogRepositoryImpl
implements EventLogRepository {
    private NamedParameterJdbcTemplate jdbcTemplate;

    public EventLogRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<EventLog> findByLockedByAndLockedUntilGreaterThan(String lockedBy, Instant lockedUntil) {
        HashMap<String, Object> namedParameterMap = new HashMap<String, Object>();
        namedParameterMap.put("lockedBy", lockedBy);
        namedParameterMap.put("lockedUntil", this.toSqlTimestamp(lockedUntil));
        return this.jdbcTemplate.query("SELECT * FROM nakadi_events.event_log where locked_by = :lockedBy and locked_until > :lockedUntil", namedParameterMap, (RowMapper)new BeanPropertyRowMapper(EventLog.class));
    }

    public void lockSomeMessages(String lockId, Instant now, Instant lockExpires) {
        HashMap<String, Object> namedParameterMap = new HashMap<String, Object>();
        namedParameterMap.put("lockId", lockId);
        namedParameterMap.put("now", this.toSqlTimestamp(now));
        namedParameterMap.put("lockExpires", this.toSqlTimestamp(lockExpires));
        this.jdbcTemplate.update("UPDATE nakadi_events.event_log SET locked_by = :lockId, locked_until = :lockExpires where locked_until is null or locked_until < :now", namedParameterMap);
    }

    public void delete(EventLog eventLog) {
        HashMap<String, Integer> namedParameterMap = new HashMap<String, Integer>();
        namedParameterMap.put("id", eventLog.getId());
        this.jdbcTemplate.update("DELETE FROM nakadi_events.event_log where id = :id", namedParameterMap);
    }

    public void persist(EventLog eventLog) {
        Timestamp now = this.toSqlTimestamp(Instant.now());
        MapSqlParameterSource namedParameterMap = new MapSqlParameterSource();
        namedParameterMap.addValue("eventType", (Object)eventLog.getEventType());
        namedParameterMap.addValue("eventBodyData", (Object)eventLog.getEventBodyData());
        namedParameterMap.addValue("flowId", (Object)eventLog.getFlowId());
        namedParameterMap.addValue("created", (Object)now);
        namedParameterMap.addValue("lastModified", (Object)now);
        namedParameterMap.addValue("lockedBy", (Object)eventLog.getLockedBy());
        namedParameterMap.addValue("lockedUntil", (Object)eventLog.getLockedUntil());
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update("INSERT INTO     nakadi_events.event_log     (event_type, event_body_data, flow_id, created, last_modified, locked_by, locked_until) VALUES     (:eventType, :eventBodyData, :flowId, :created, :lastModified, :lockedBy, :lockedUntil)", (SqlParameterSource)namedParameterMap, (KeyHolder)generatedKeyHolder);
        eventLog.setId((Integer)generatedKeyHolder.getKeys().get("id"));
    }

    private Timestamp toSqlTimestamp(Instant now) {
        if (now == null) {
            return null;
        }
        return Timestamp.from(now);
    }

    public void deleteAll() {
        this.jdbcTemplate.update("DELETE from nakadi_events.event_log", new HashMap());
    }

    public EventLog findOne(Integer id) {
        HashMap<String, Integer> namedParameterMap = new HashMap<String, Integer>();
        namedParameterMap.put("id", id);
        try {
            return (EventLog)this.jdbcTemplate.queryForObject("SELECT * FROM nakadi_events.event_log where id = :id", namedParameterMap, (RowMapper)new BeanPropertyRowMapper(EventLog.class));
        }
        catch (EmptyResultDataAccessException ignored) {
            return null;
        }
    }
}

