/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.snapshots.impl;

import java.util.Set;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.zalando.nakadiproducer.flowid.FlowIdComponent;
import org.zalando.nakadiproducer.snapshots.impl.SnapshotCreationService;

@ConfigurationProperties(value="endpoints.snapshot-event-creation")
public class SnapshotEventCreationEndpoint
extends AbstractEndpoint<SnapshotReport> {
    private final SnapshotCreationService snapshotCreationService;
    private final FlowIdComponent flowIdComponent;

    public SnapshotEventCreationEndpoint(SnapshotCreationService snapshotCreationService, FlowIdComponent flowIdComponent) {
        super("snapshot_event_creation", true, true);
        this.snapshotCreationService = snapshotCreationService;
        this.flowIdComponent = flowIdComponent;
    }

    public SnapshotReport invoke() {
        return new SnapshotReport(this.snapshotCreationService.getSupportedEventTypes());
    }

    public void invoke(String eventType, String filter) {
        this.flowIdComponent.startTraceIfNoneExists();
        this.snapshotCreationService.createSnapshotEvents(eventType, filter);
    }

    public static class SnapshotReport {
        private final Set<String> supportedEventTypes;

        public SnapshotReport(Set<String> supportedEventTypes) {
            this.supportedEventTypes = supportedEventTypes;
        }

        public Set<String> getSupportedEventTypes() {
            return this.supportedEventTypes;
        }
    }
}

