/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.transmission.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.nakadiproducer.eventlog.impl.EventLog;
import org.zalando.nakadiproducer.transmission.impl.NakadiEvent;

public class EventBatcher {
    private static final Logger log = LoggerFactory.getLogger(EventBatcher.class);
    private static final long NAKADI_BATCH_SIZE_LIMIT_IN_BYTES = 50000000L;
    private final ObjectMapper objectMapper;
    private final Consumer<List<BatchItem>> publisher;
    private List<BatchItem> batch;
    private long aggregatedBatchSize;

    public EventBatcher(ObjectMapper objectMapper, Consumer<List<BatchItem>> publisher) {
        this.objectMapper = objectMapper;
        this.publisher = publisher;
        this.batch = new ArrayList<BatchItem>();
        this.aggregatedBatchSize = 0L;
    }

    public void pushEvent(EventLog eventLogEntry, NakadiEvent nakadiEvent) {
        long eventSize;
        try {
            eventSize = this.objectMapper.writeValueAsBytes((Object)nakadiEvent).length;
        }
        catch (Exception e) {
            log.error("Could not serialize event {} of type {}, skipping it.", new Object[]{eventLogEntry.getId(), eventLogEntry.getEventType(), e});
            return;
        }
        if (!this.batch.isEmpty() && (this.hasAnotherEventType(this.batch, eventLogEntry) || this.batchWouldBecomeTooBig(this.aggregatedBatchSize, eventSize))) {
            this.publisher.accept(this.batch);
            this.batch = new ArrayList<BatchItem>();
            this.aggregatedBatchSize = 0L;
        }
        this.batch.add(new BatchItem(eventLogEntry, nakadiEvent));
        this.aggregatedBatchSize += eventSize;
    }

    public void finish() {
        if (!this.batch.isEmpty()) {
            this.publisher.accept(this.batch);
        }
    }

    private boolean hasAnotherEventType(List<BatchItem> batch, EventLog event) {
        return !event.getEventType().equals(batch.get(0).getEventLogEntry().getEventType());
    }

    private boolean batchWouldBecomeTooBig(long aggregatedBatchSize, long eventSize) {
        return (double)(aggregatedBatchSize + eventSize) > 4.0E7;
    }

    protected static class BatchItem {
        EventLog eventLogEntry;
        NakadiEvent nakadiEvent;

        public BatchItem(EventLog eventLogEntry, NakadiEvent nakadiEvent) {
            this.eventLogEntry = eventLogEntry;
            this.nakadiEvent = nakadiEvent;
        }

        public EventLog getEventLogEntry() {
            return this.eventLogEntry;
        }

        public NakadiEvent getNakadiEvent() {
            return this.nakadiEvent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchItem)) {
                return false;
            }
            BatchItem other = (BatchItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EventLog this$eventLogEntry = this.getEventLogEntry();
            EventLog other$eventLogEntry = other.getEventLogEntry();
            if (this$eventLogEntry == null ? other$eventLogEntry != null : !this$eventLogEntry.equals(other$eventLogEntry)) {
                return false;
            }
            NakadiEvent this$nakadiEvent = this.getNakadiEvent();
            NakadiEvent other$nakadiEvent = other.getNakadiEvent();
            return !(this$nakadiEvent == null ? other$nakadiEvent != null : !((Object)this$nakadiEvent).equals(other$nakadiEvent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BatchItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EventLog $eventLogEntry = this.getEventLogEntry();
            result = result * 59 + ($eventLogEntry == null ? 43 : $eventLogEntry.hashCode());
            NakadiEvent $nakadiEvent = this.getNakadiEvent();
            result = result * 59 + ($nakadiEvent == null ? 43 : ((Object)$nakadiEvent).hashCode());
            return result;
        }

        public String toString() {
            return "EventBatcher.BatchItem(eventLogEntry=" + this.getEventLogEntry() + ", nakadiEvent=" + this.getNakadiEvent() + ")";
        }
    }
}

