/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.transmission;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.zalando.nakadiproducer.transmission.NakadiPublishingClient;

public class MockNakadiPublishingClient
implements NakadiPublishingClient {
    private final ObjectMapper objectMapper;
    private final MultiValueMap<String, String> sentEvents = new LinkedMultiValueMap();

    public MockNakadiPublishingClient() {
        this(MockNakadiPublishingClient.createDefaultObjectMapper());
    }

    public MockNakadiPublishingClient(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public synchronized void publish(String eventType, List<?> nakadiEvents) throws Exception {
        nakadiEvents.stream().map(this::transformToJson).forEach(e -> this.sentEvents.add((Object)eventType, e));
    }

    public synchronized List<String> getSentEvents(String eventType) {
        ArrayList<String> events = new ArrayList<String>();
        List sentEvents = (List)this.sentEvents.get((Object)eventType);
        if (sentEvents != null) {
            events.addAll(sentEvents);
        }
        return events;
    }

    public synchronized void clearSentEvents() {
        this.sentEvents.clear();
    }

    private String transformToJson(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModules(new Module[]{new Jdk8Module(), new ParameterNamesModule(), new JavaTimeModule()});
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return objectMapper;
    }
}

