/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.eventlog.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.zalando.nakadiproducer.eventlog.EventLogWriter;
import org.zalando.nakadiproducer.eventlog.impl.DataChangeEventEnvelope;
import org.zalando.nakadiproducer.eventlog.impl.EventDataOperation;
import org.zalando.nakadiproducer.eventlog.impl.EventLog;
import org.zalando.nakadiproducer.eventlog.impl.EventLogRepository;
import org.zalando.nakadiproducer.flowid.FlowIdComponent;

public class EventLogWriterImpl
implements EventLogWriter {
    private final EventLogRepository eventLogRepository;
    private final ObjectMapper objectMapper;
    private final FlowIdComponent flowIdComponent;

    public EventLogWriterImpl(EventLogRepository eventLogRepository, ObjectMapper objectMapper, FlowIdComponent flowIdComponent) {
        this.eventLogRepository = eventLogRepository;
        this.objectMapper = objectMapper;
        this.flowIdComponent = flowIdComponent;
    }

    @Override
    @Transactional
    public void fireCreateEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createEventLog(eventType, new DataChangeEventEnvelope(EventDataOperation.CREATE.toString(), dataType, data));
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireCreateEvents(String eventType, String dataType, Collection<?> data) {
        this.eventLogRepository.persist(this.createEventLogs(eventType, EventDataOperation.CREATE, dataType, data));
    }

    @Override
    @Transactional
    public void fireUpdateEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createEventLog(eventType, new DataChangeEventEnvelope(EventDataOperation.UPDATE.toString(), dataType, data));
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireUpdateEvents(String eventType, String dataType, Collection<?> data) {
        this.eventLogRepository.persist(this.createEventLogs(eventType, EventDataOperation.UPDATE, dataType, data));
    }

    @Override
    @Transactional
    public void fireDeleteEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createEventLog(eventType, new DataChangeEventEnvelope(EventDataOperation.DELETE.toString(), dataType, data));
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireDeleteEvents(String eventType, String dataType, Collection<?> data) {
        this.eventLogRepository.persist(this.createEventLogs(eventType, EventDataOperation.DELETE, dataType, data));
    }

    @Override
    @Transactional
    public void fireSnapshotEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createEventLog(eventType, new DataChangeEventEnvelope(EventDataOperation.SNAPSHOT.toString(), dataType, data));
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireSnapshotEvents(String eventType, String dataType, Collection<?> data) {
        this.eventLogRepository.persist(this.createEventLogs(eventType, EventDataOperation.SNAPSHOT, dataType, data));
    }

    @Override
    @Transactional
    public void fireBusinessEvent(String eventType, Object payload) {
        EventLog eventLog = this.createEventLog(eventType, payload);
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireBusinessEvents(String eventType, Collection<Object> payload) {
        Collection<EventLog> eventLogs = this.createEventLogs(eventType, payload);
        this.eventLogRepository.persist(eventLogs);
    }

    private Collection<EventLog> createEventLogs(String eventType, Collection<Object> eventPayloads) {
        return eventPayloads.stream().map(payload -> this.createEventLog(eventType, payload)).collect(Collectors.toList());
    }

    private EventLog createEventLog(String eventType, Object eventPayload) {
        EventLog eventLog = new EventLog();
        eventLog.setEventType(eventType);
        try {
            eventLog.setEventBodyData(this.objectMapper.writeValueAsString(eventPayload));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("could not map object to json: " + eventPayload.toString(), e);
        }
        eventLog.setFlowId(this.flowIdComponent.getXFlowIdValue());
        return eventLog;
    }

    private Collection<EventLog> createEventLogs(String eventType, EventDataOperation eventDataOperation, String dataType, Collection<?> data) {
        return data.stream().map(payload -> this.createEventLog(eventType, new DataChangeEventEnvelope(eventDataOperation.toString(), dataType, payload))).collect(Collectors.toList());
    }
}

