/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.eventlog.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.zalando.nakadiproducer.eventlog.CompactionKeyExtractor;
import org.zalando.nakadiproducer.eventlog.EventLogWriter;
import org.zalando.nakadiproducer.eventlog.impl.DataChangeEventEnvelope;
import org.zalando.nakadiproducer.eventlog.impl.EventDataOperation;
import org.zalando.nakadiproducer.eventlog.impl.EventLog;
import org.zalando.nakadiproducer.eventlog.impl.EventLogRepository;
import org.zalando.nakadiproducer.flowid.FlowIdComponent;

public class EventLogWriterImpl
implements EventLogWriter {
    private final EventLogRepository eventLogRepository;
    private final ObjectMapper objectMapper;
    private final FlowIdComponent flowIdComponent;
    private final Map<String, CompactionKeyExtractor<Object>> extractors;
    private static final CompactionKeyExtractor<Object> NOOP_EXTRACTOR = o -> null;

    public EventLogWriterImpl(EventLogRepository eventLogRepository, ObjectMapper objectMapper, FlowIdComponent flowIdComponent) {
        this.eventLogRepository = eventLogRepository;
        this.objectMapper = objectMapper;
        this.flowIdComponent = flowIdComponent;
        this.extractors = new HashMap<String, CompactionKeyExtractor<Object>>();
    }

    @Override
    @Transactional
    public void fireCreateEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createDataEventLog(eventType, EventDataOperation.CREATE, dataType, data);
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireCreateEvents(String eventType, String dataType, Collection<?> data) {
        this.eventLogRepository.persist(this.createDataEventLogs(eventType, EventDataOperation.CREATE, dataType, data));
    }

    @Override
    @Transactional
    public void fireUpdateEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createDataEventLog(eventType, EventDataOperation.UPDATE, dataType, data);
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireUpdateEvents(String eventType, String dataType, Collection<?> data) {
        this.eventLogRepository.persist(this.createDataEventLogs(eventType, EventDataOperation.UPDATE, dataType, data));
    }

    @Override
    @Transactional
    public void fireDeleteEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createDataEventLog(eventType, EventDataOperation.DELETE, dataType, data);
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireDeleteEvents(String eventType, String dataType, Collection<?> data) {
        this.eventLogRepository.persist(this.createDataEventLogs(eventType, EventDataOperation.DELETE, dataType, data));
    }

    @Override
    @Transactional
    public void fireSnapshotEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createDataEventLog(eventType, EventDataOperation.SNAPSHOT, dataType, data);
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireSnapshotEvents(String eventType, String dataType, Collection<?> data) {
        this.eventLogRepository.persist(this.createDataEventLogs(eventType, EventDataOperation.SNAPSHOT, dataType, data));
    }

    @Override
    @Transactional
    public void fireBusinessEvent(String eventType, Object payload) {
        EventLog eventLog = this.createEventLog(eventType, payload, this.getCompactionKeyFor(eventType, payload));
        this.eventLogRepository.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireBusinessEvents(String eventType, Collection<Object> payload) {
        Collection<EventLog> eventLogs = this.createBusinessEventLogs(eventType, payload);
        this.eventLogRepository.persist(eventLogs);
    }

    private Collection<EventLog> createBusinessEventLogs(String eventType, Collection<Object> eventPayloads) {
        CompactionKeyExtractor<Object> extractor = this.getExtractorFor(eventType);
        return eventPayloads.stream().map(payload -> this.createEventLog(eventType, payload, extractor.getCompactionKeyFor(payload))).collect(Collectors.toList());
    }

    private Collection<EventLog> createDataEventLogs(String eventType, EventDataOperation eventDataOperation, String dataType, Collection<?> data) {
        CompactionKeyExtractor<Object> extractor = this.getExtractorFor(eventType);
        return data.stream().map(payload -> this.createEventLog(eventType, new DataChangeEventEnvelope(eventDataOperation.toString(), dataType, payload), extractor.getCompactionKeyFor(payload))).collect(Collectors.toList());
    }

    private EventLog createDataEventLog(String eventType, EventDataOperation dataOp, String dataType, Object data) {
        return this.createEventLog(eventType, new DataChangeEventEnvelope(dataOp.toString(), dataType, data), this.getCompactionKeyFor(eventType, data));
    }

    private EventLog createEventLog(String eventType, Object eventPayload, String compactionKey) {
        EventLog eventLog = new EventLog();
        eventLog.setEventType(eventType);
        try {
            eventLog.setEventBodyData(this.objectMapper.writeValueAsString(eventPayload));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("could not map object to json: " + eventPayload.toString(), e);
        }
        eventLog.setCompactionKey(compactionKey);
        eventLog.setFlowId(this.flowIdComponent.getXFlowIdValue());
        return eventLog;
    }

    private String getCompactionKeyFor(String eventType, Object payload) {
        return this.getExtractorFor(eventType).getCompactionKeyFor(payload);
    }

    private CompactionKeyExtractor<Object> getExtractorFor(String eventType) {
        return this.extractors.getOrDefault(eventType, NOOP_EXTRACTOR);
    }

    @Override
    public <X> void registerCompactionKeyExtractor(String eventType, Class<X> dataType, CompactionKeyExtractor<X> extractor) {
        this.extractors.put(eventType, new TypedCompactionExtractorWrapper<X>(extractor, dataType, this.getExtractorFor(eventType)));
    }

    private static class TypedCompactionExtractorWrapper<X>
    implements CompactionKeyExtractor<Object> {
        final CompactionKeyExtractor<X> extractor;
        final Class<X> type;
        final CompactionKeyExtractor<Object> next;

        @Override
        public String getCompactionKeyFor(Object o) {
            if (this.type.isInstance(o)) {
                return this.extractor.getCompactionKeyFor(this.type.cast(o));
            }
            return this.next.getCompactionKeyFor(o);
        }

        public TypedCompactionExtractorWrapper(CompactionKeyExtractor<X> extractor, Class<X> type, CompactionKeyExtractor<Object> next) {
            this.extractor = extractor;
            this.type = type;
            this.next = next;
        }
    }
}

