/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.eventlog;

import java.util.Optional;
import java.util.function.Function;
import org.zalando.nakadiproducer.eventlog.CompactionKeyExtractors;

public interface CompactionKeyExtractor {
    default public String getKeyOrNull(Object payload) {
        return this.tryGetKeyFor(payload).orElse(null);
    }

    public Optional<String> tryGetKeyFor(Object var1);

    public String getEventType();

    public static <X> CompactionKeyExtractor of(String eventType, Class<X> type, Function<X, String> extractorFunction) {
        return new CompactionKeyExtractors.TypedCompactionKeyExtractor<X>(eventType, type, extractorFunction);
    }

    public static CompactionKeyExtractor ofOptional(String eventType, Function<Object, Optional<String>> extractor) {
        return new CompactionKeyExtractors.SimpleCompactionKeyExtractor(eventType, extractor);
    }

    public static CompactionKeyExtractor ofNullable(String eventType, Function<Object, String> extractor) {
        return new CompactionKeyExtractors.SimpleCompactionKeyExtractor(eventType, extractor.andThen(Optional::ofNullable));
    }

    public static CompactionKeyExtractor of(String eventType, Function<Object, String> extractor) {
        return new CompactionKeyExtractors.SimpleCompactionKeyExtractor(eventType, extractor.andThen(Optional::of));
    }
}

