/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.eventlog.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.zalando.fahrschein.Preconditions;
import org.zalando.nakadiproducer.eventlog.CompactionKeyExtractor;
import org.zalando.nakadiproducer.eventlog.EventLogWriter;
import org.zalando.nakadiproducer.eventlog.impl.DataChangeEventEnvelope;
import org.zalando.nakadiproducer.eventlog.impl.EventDataOperation;
import org.zalando.nakadiproducer.eventlog.impl.EventLog;
import org.zalando.nakadiproducer.eventlog.impl.EventLogRepository;
import org.zalando.nakadiproducer.flowid.FlowIdComponent;

public class EventLogWriterImpl
implements EventLogWriter {
    private static final CompactionKeyExtractor NOOP_EXTRACTOR = CompactionKeyExtractor.ofOptional("doesn't matter", o -> Optional.empty());
    private final EventLogRepository eventLogRepository;
    private final ObjectMapper objectMapper;
    private final FlowIdComponent flowIdComponent;
    private final Map<String, CompactionKeyExtractor> extractorsByEventType;
    private final boolean deleteAfterWrite;

    public EventLogWriterImpl(EventLogRepository eventLogRepository, ObjectMapper objectMapper, FlowIdComponent flowIdComponent, List<CompactionKeyExtractor> keyExtractors, boolean deleteAfterWrite) {
        this.eventLogRepository = eventLogRepository;
        this.objectMapper = objectMapper;
        this.flowIdComponent = flowIdComponent;
        this.extractorsByEventType = keyExtractors.stream().collect(Collectors.groupingBy(CompactionKeyExtractor::getEventType, Collectors.collectingAndThen(Collectors.toList(), EventLogWriterImpl::joinCompactors)));
        this.deleteAfterWrite = deleteAfterWrite;
    }

    private static CompactionKeyExtractor joinCompactors(List<CompactionKeyExtractor> list) {
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
        if (list.size() == 1) {
            return list.get(0);
        }
        return CompactionKeyExtractor.ofOptional(list.get(0).getEventType(), o -> list.stream().flatMap(ex -> ex.tryGetKeyFor(o).stream()).findAny());
    }

    @Override
    @Transactional
    public void fireCreateEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createDataEventLog(eventType, EventDataOperation.CREATE, dataType, data);
        this.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireCreateEvents(String eventType, String dataType, Collection<?> data) {
        this.persistSeveral(this.createDataEventLogs(eventType, EventDataOperation.CREATE, dataType, data));
    }

    @Override
    @Transactional
    public void fireUpdateEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createDataEventLog(eventType, EventDataOperation.UPDATE, dataType, data);
        this.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireUpdateEvents(String eventType, String dataType, Collection<?> data) {
        this.persistSeveral(this.createDataEventLogs(eventType, EventDataOperation.UPDATE, dataType, data));
    }

    @Override
    @Transactional
    public void fireDeleteEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createDataEventLog(eventType, EventDataOperation.DELETE, dataType, data);
        this.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireDeleteEvents(String eventType, String dataType, Collection<?> data) {
        this.persistSeveral(this.createDataEventLogs(eventType, EventDataOperation.DELETE, dataType, data));
    }

    @Override
    @Transactional
    public void fireSnapshotEvent(String eventType, String dataType, Object data) {
        EventLog eventLog = this.createDataEventLog(eventType, EventDataOperation.SNAPSHOT, dataType, data);
        this.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireSnapshotEvents(String eventType, String dataType, Collection<?> data) {
        this.persistSeveral(this.createDataEventLogs(eventType, EventDataOperation.SNAPSHOT, dataType, data));
    }

    @Override
    @Transactional
    public void fireBusinessEvent(String eventType, Object payload) {
        EventLog eventLog = this.createEventLog(eventType, payload, this.getCompactionKeyFor(eventType, payload));
        this.persist(eventLog);
    }

    @Override
    @Transactional
    public void fireBusinessEvents(String eventType, Collection<?> payload) {
        Collection<EventLog> eventLogs = this.createBusinessEventLogs(eventType, payload);
        this.persistSeveral(eventLogs);
    }

    private void persist(EventLog eventLog) {
        this.persistSeveral(Collections.singleton(eventLog));
    }

    private void persistSeveral(Collection<EventLog> eventLogs) {
        if (this.deleteAfterWrite) {
            this.eventLogRepository.persistAndDelete(eventLogs);
        } else {
            this.eventLogRepository.persist(eventLogs);
        }
    }

    private Collection<EventLog> createBusinessEventLogs(String eventType, Collection<?> eventPayloads) {
        CompactionKeyExtractor extractor = this.getKeyExtractorFor(eventType);
        return eventPayloads.stream().map(payload -> this.createEventLog(eventType, payload, extractor.getKeyOrNull(payload))).collect(Collectors.toList());
    }

    private Collection<EventLog> createDataEventLogs(String eventType, EventDataOperation eventDataOperation, String dataType, Collection<?> data) {
        CompactionKeyExtractor extractor = this.getKeyExtractorFor(eventType);
        String dataOp = eventDataOperation.toString();
        return data.stream().map(payload -> this.createEventLog(eventType, new DataChangeEventEnvelope(dataOp, dataType, payload), extractor.getKeyOrNull(payload))).collect(Collectors.toList());
    }

    private EventLog createDataEventLog(String eventType, EventDataOperation dataOp, String dataType, Object data) {
        return this.createEventLog(eventType, new DataChangeEventEnvelope(dataOp.toString(), dataType, data), this.getCompactionKeyFor(eventType, data));
    }

    private String getCompactionKeyFor(String eventType, Object payload) {
        return this.getKeyExtractorFor(eventType).getKeyOrNull(payload);
    }

    private CompactionKeyExtractor getKeyExtractorFor(String eventType) {
        return this.extractorsByEventType.getOrDefault(eventType, NOOP_EXTRACTOR);
    }

    private EventLog createEventLog(String eventType, Object eventPayload, String compactionKey) {
        EventLog eventLog = new EventLog();
        eventLog.setEventType(eventType);
        try {
            eventLog.setEventBodyData(this.objectMapper.writeValueAsString(eventPayload));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("could not map object to json: " + eventPayload.toString(), e);
        }
        eventLog.setCompactionKey(compactionKey);
        eventLog.setFlowId(this.flowIdComponent.getXFlowIdValue());
        return eventLog;
    }
}

