/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.eventlog;

import java.util.Optional;
import java.util.function.Function;
import org.zalando.nakadiproducer.eventlog.CompactionKeyExtractor;

final class CompactionKeyExtractors {
    CompactionKeyExtractors() {
    }

    static class TypedCompactionKeyExtractor<X>
    implements CompactionKeyExtractor {
        private final String eventType;
        private final Class<X> type;
        private final Function<X, String> extractorFunction;

        @Override
        public Optional<String> tryGetKeyFor(Object o) {
            if (this.type.isInstance(o)) {
                return Optional.of(this.extractorFunction.apply(this.type.cast(o)));
            }
            return Optional.empty();
        }

        TypedCompactionKeyExtractor(String eventType, Class<X> type, Function<X, String> extractorFunction) {
            this.eventType = eventType;
            this.type = type;
            this.extractorFunction = extractorFunction;
        }

        @Override
        public String getEventType() {
            return this.eventType;
        }
    }

    static class SimpleCompactionKeyExtractor
    implements CompactionKeyExtractor {
        private final String eventType;
        private final Function<Object, Optional<String>> extractorFunction;

        @Override
        public Optional<String> tryGetKeyFor(Object o) {
            return this.extractorFunction.apply(o);
        }

        SimpleCompactionKeyExtractor(String eventType, Function<Object, Optional<String>> extractorFunction) {
            this.eventType = eventType;
            this.extractorFunction = extractorFunction;
        }

        @Override
        public String getEventType() {
            return this.eventType;
        }
    }
}

