/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.snapshots.impl;

import java.util.List;
import java.util.Set;
import org.zalando.nakadiproducer.eventlog.EventLogWriter;
import org.zalando.nakadiproducer.snapshots.SnapshotEventProvider;

public class SnapshotCreationService {
    private final SnapshotEventProvider snapshotEventProvider;
    private final EventLogWriter eventLogWriter;

    public SnapshotCreationService(SnapshotEventProvider snapshotEventProvider, EventLogWriter eventLogWriter) {
        this.snapshotEventProvider = snapshotEventProvider;
        this.eventLogWriter = eventLogWriter;
    }

    public void createSnapshotEvents(String eventType) {
        List<SnapshotEventProvider.Snapshot> snapshots;
        Object lastProcessedId = null;
        while (!(snapshots = this.snapshotEventProvider.getSnapshot(eventType, lastProcessedId)).isEmpty()) {
            for (SnapshotEventProvider.Snapshot snapshot : snapshots) {
                this.eventLogWriter.fireSnapshotEvent(eventType, snapshot.getDataType(), snapshot.getData());
                lastProcessedId = snapshot.getId();
            }
        }
    }

    public Set<String> getSupportedEventTypes() {
        return this.snapshotEventProvider.getSupportedEventTypes();
    }
}

