/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.transmission.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.UUID;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.nakadiproducer.eventlog.impl.EventLog;
import org.zalando.nakadiproducer.eventlog.impl.EventLogRepository;
import org.zalando.nakadiproducer.transmission.NakadiPublishingClient;
import org.zalando.nakadiproducer.transmission.impl.NakadiEvent;
import org.zalando.nakadiproducer.transmission.impl.NakadiMetadata;

public class EventTransmissionService {
    private static final Logger log = LoggerFactory.getLogger(EventTransmissionService.class);
    private EventLogRepository eventLogRepository;
    private NakadiPublishingClient nakadiPublishingClient;
    private ObjectMapper objectMapper;

    public EventTransmissionService(EventLogRepository eventLogRepository, NakadiPublishingClient nakadiPublishingClient, ObjectMapper objectMapper) {
        this.eventLogRepository = eventLogRepository;
        this.nakadiPublishingClient = nakadiPublishingClient;
        this.objectMapper = objectMapper;
    }

    @Transactional
    public Collection<EventLog> lockSomeEvents() {
        String lockId = UUID.randomUUID().toString();
        log.debug("Locking events for replication with lockId {}", (Object)lockId);
        this.eventLogRepository.lockSomeMessages(lockId, Instant.now(), Instant.now().plus(10L, ChronoUnit.MINUTES));
        return this.eventLogRepository.findByLockedByAndLockedUntilGreaterThan(lockId, Instant.now());
    }

    @Transactional
    public void sendEvent(EventLog eventLog) {
        try {
            this.nakadiPublishingClient.publish(eventLog.getEventType(), Collections.singletonList(this.mapToNakadiEvent(eventLog)));
            log.info("Event {} locked by {} was sucessfully transmitted to nakadi", (Object)eventLog.getId(), (Object)eventLog.getLockedBy());
            this.eventLogRepository.delete(eventLog);
        }
        catch (Exception e) {
            log.error("Event {} locked by {} could not be transmitted to nakadi: {}", new Object[]{eventLog.getId(), eventLog.getLockedBy(), e.getMessage()});
        }
    }

    public NakadiEvent mapToNakadiEvent(EventLog event) {
        HashMap payloadDTO;
        NakadiEvent nakadiEvent = new NakadiEvent();
        NakadiMetadata metadata = new NakadiMetadata();
        metadata.setEid(this.convertToUUID(event.getId()));
        metadata.setOccuredAt(event.getCreated());
        metadata.setFlowId(event.getFlowId());
        nakadiEvent.setMetadata(metadata);
        try {
            payloadDTO = (HashMap)this.objectMapper.readValue(event.getEventBodyData(), (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
        }
        catch (IOException e) {
            log.error("An error occurred at JSON deserialization", (Throwable)e);
            throw new UncheckedIOException(e);
        }
        nakadiEvent.setData(payloadDTO);
        return nakadiEvent;
    }

    private String convertToUUID(int number) {
        return new UUID(0L, number).toString();
    }
}

