/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadiproducer.snapshots.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.zalando.nakadiproducer.eventlog.EventLogWriter;
import org.zalando.nakadiproducer.snapshots.Snapshot;
import org.zalando.nakadiproducer.snapshots.SnapshotEventGenerator;
import org.zalando.nakadiproducer.snapshots.UnknownEventTypeException;

public class SnapshotCreationService {
    private final Map<String, SnapshotEventGenerator> snapshotEventProviders;
    private final EventLogWriter eventLogWriter;

    public SnapshotCreationService(List<SnapshotEventGenerator> snapshotEventGenerators, EventLogWriter eventLogWriter) {
        this.snapshotEventProviders = snapshotEventGenerators.stream().collect(Collectors.toMap(SnapshotEventGenerator::getSupportedEventType, Function.identity()));
        this.eventLogWriter = eventLogWriter;
    }

    public void createSnapshotEvents(String eventType, String filter) {
        List<Snapshot> snapshots;
        SnapshotEventGenerator snapshotEventGenerator = this.snapshotEventProviders.get(eventType);
        if (snapshotEventGenerator == null) {
            throw new UnknownEventTypeException(eventType);
        }
        Object lastProcessedId = null;
        while (!(snapshots = snapshotEventGenerator.generateSnapshots(lastProcessedId, filter)).isEmpty()) {
            for (Snapshot snapshot : snapshots) {
                this.eventLogWriter.fireSnapshotEvent(eventType, snapshot.getDataType(), snapshot.getData());
                lastProcessedId = snapshot.getId();
            }
        }
    }

    public Set<String> getSupportedEventTypes() {
        return Collections.unmodifiableSet(this.snapshotEventProviders.keySet());
    }
}

