/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.domain.EventCategory;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.domain.EventTypeStatistics;
import org.zalando.nakadi.enrichment.Enrichment;
import org.zalando.nakadi.exceptions.DuplicatedEventTypeNameException;
import org.zalando.nakadi.exceptions.InternalNakadiException;
import org.zalando.nakadi.exceptions.InvalidEventTypeException;
import org.zalando.nakadi.exceptions.NakadiException;
import org.zalando.nakadi.exceptions.NoSuchEventTypeException;
import org.zalando.nakadi.exceptions.NoSuchPartitionStrategyException;
import org.zalando.nakadi.exceptions.TopicCreationException;
import org.zalando.nakadi.exceptions.TopicDeletionException;
import org.zalando.nakadi.partitioning.PartitionResolver;
import org.zalando.nakadi.repository.EventTypeRepository;
import org.zalando.nakadi.repository.TopicRepository;
import org.zalando.nakadi.security.Client;
import org.zalando.nakadi.service.Result;
import org.zalando.nakadi.util.FeatureToggleService;
import org.zalando.nakadi.util.UUIDGenerator;

@Component
public class EventTypeService {
    private static final Logger LOG = LoggerFactory.getLogger(EventTypeService.class);
    private final EventTypeRepository eventTypeRepository;
    private final TopicRepository topicRepository;
    private final PartitionResolver partitionResolver;
    private final Enrichment enrichment;
    private final UUIDGenerator uuidGenerator;
    private final FeatureToggleService featureToggleService;

    @Autowired
    public EventTypeService(EventTypeRepository eventTypeRepository, TopicRepository topicRepository, PartitionResolver partitionResolver, Enrichment enrichment, UUIDGenerator uuidGenerator, FeatureToggleService featureToggleService) {
        this.eventTypeRepository = eventTypeRepository;
        this.topicRepository = topicRepository;
        this.partitionResolver = partitionResolver;
        this.enrichment = enrichment;
        this.uuidGenerator = uuidGenerator;
        this.featureToggleService = featureToggleService;
    }

    public List<EventType> list() {
        return this.eventTypeRepository.list();
    }

    public Result<Void> create(EventType eventType) {
        try {
            this.assignTopic(eventType);
            this.validateSchema(eventType);
            this.enrichment.validate(eventType);
            this.partitionResolver.validate(eventType);
            this.eventTypeRepository.saveEventType(eventType);
            this.topicRepository.createTopic(eventType);
            return Result.ok();
        }
        catch (DuplicatedEventTypeNameException | InvalidEventTypeException | NoSuchPartitionStrategyException e) {
            LOG.debug("Failed to create EventType.", (Throwable)e);
            return Result.problem(e.asProblem());
        }
        catch (TopicCreationException e) {
            LOG.error("Problem creating kafka topic. Rolling back event type database registration.", (Throwable)e);
            try {
                this.eventTypeRepository.removeEventType(eventType.getTopic());
            }
            catch (NakadiException e1) {
                return Result.problem(e.asProblem());
            }
            return Result.problem(e.asProblem());
        }
        catch (NakadiException e) {
            LOG.error("Error creating event type " + eventType, (Throwable)e);
            return Result.problem(e.asProblem());
        }
    }

    public Result<Void> delete(String eventTypeName, Client client) {
        try {
            Optional<EventType> eventType = this.eventTypeRepository.findByNameO(eventTypeName);
            if (!eventType.isPresent()) {
                return Result.notFound("EventType \"" + eventTypeName + "\" does not exist.");
            }
            if (!client.is(eventType.get().getOwningApplication())) {
                return Result.forbidden("You don't have access to this event type");
            }
            this.eventTypeRepository.removeEventType(eventTypeName);
            this.topicRepository.deleteTopic(eventType.get().getTopic());
            return Result.ok();
        }
        catch (TopicDeletionException e) {
            LOG.error("Problem deleting kafka topic " + eventTypeName, (Throwable)e);
            return Result.problem(e.asProblem());
        }
        catch (NakadiException e) {
            LOG.error("Error deleting event type " + eventTypeName, (Throwable)e);
            return Result.problem(e.asProblem());
        }
    }

    public Result<Void> update(String eventTypeName, EventType eventType, Client client) {
        try {
            EventType original = this.eventTypeRepository.findByName(eventTypeName);
            if (!client.is(original.getOwningApplication())) {
                return Result.forbidden("You don't have access to this event type");
            }
            this.validateUpdate(eventTypeName, eventType);
            this.enrichment.validate(eventType);
            this.partitionResolver.validate(eventType);
            this.eventTypeRepository.update(eventType);
            return Result.ok();
        }
        catch (InvalidEventTypeException e) {
            return Result.problem(e.asProblem());
        }
        catch (NoSuchEventTypeException e) {
            LOG.debug("Could not find EventType: {}", (Object)eventTypeName);
            return Result.problem(e.asProblem());
        }
        catch (NakadiException e) {
            LOG.error("Unable to update event type", (Throwable)e);
            return Result.problem(e.asProblem());
        }
    }

    public Result<EventType> get(String eventTypeName) {
        try {
            EventType eventType = this.eventTypeRepository.findByName(eventTypeName);
            return Result.ok(eventType);
        }
        catch (NoSuchEventTypeException e) {
            LOG.debug("Could not find EventType: {}", (Object)eventTypeName);
            return Result.problem(e.asProblem());
        }
        catch (InternalNakadiException e) {
            LOG.error("Problem loading event type " + eventTypeName, (Throwable)e);
            return Result.problem(e.asProblem());
        }
    }

    private void validateUpdate(String name, EventType eventType) throws NoSuchEventTypeException, InternalNakadiException, InvalidEventTypeException, NoSuchPartitionStrategyException {
        EventType existingEventType = this.eventTypeRepository.findByName(name);
        this.validateName(name, eventType);
        this.validatePartitionKeys(eventType);
        this.validateSchemaChange(eventType, existingEventType);
        eventType.setDefaultStatistic(this.validateStatisticsUpdate(existingEventType.getDefaultStatistic(), eventType.getDefaultStatistic()));
    }

    private EventTypeStatistics validateStatisticsUpdate(EventTypeStatistics existing, EventTypeStatistics newStatistics) throws InvalidEventTypeException {
        if (existing != null && newStatistics == null) {
            return existing;
        }
        if (!Objects.equals(existing, newStatistics)) {
            throw new InvalidEventTypeException("default statistics must not be changed");
        }
        return newStatistics;
    }

    private void validateName(String name, EventType eventType) throws InvalidEventTypeException {
        if (!eventType.getName().equals(name)) {
            throw new InvalidEventTypeException("path does not match resource name");
        }
    }

    private void validateSchemaChange(EventType eventType, EventType existingEventType) throws InvalidEventTypeException {
        if (!existingEventType.getSchema().equals(eventType.getSchema())) {
            throw new InvalidEventTypeException("schema must not be changed");
        }
    }

    private void validatePartitionKeys(EventType eventType) throws InvalidEventTypeException {
        if (!this.featureToggleService.isFeatureEnabled(FeatureToggleService.Feature.CHECK_PARTITIONS_KEYS)) {
            return;
        }
        try {
            JSONObject schemaAsJson = new JSONObject(eventType.getSchema().getSchema());
            List absentFields = eventType.getPartitionKeyFields().stream().filter(field -> !this.hasReservedField(eventType, schemaAsJson, (String)field)).collect(Collectors.toList());
            if (!absentFields.isEmpty()) {
                throw new InvalidEventTypeException("partition_key_fields " + absentFields + " absent in schema");
            }
        }
        catch (JSONException e) {
            throw new InvalidEventTypeException("schema must be a valid json");
        }
        catch (SchemaException e) {
            throw new InvalidEventTypeException("schema must be a valid json-schema");
        }
    }

    private void validateSchema(EventType eventType) throws InvalidEventTypeException {
        try {
            JSONObject schemaAsJson = new JSONObject(eventType.getSchema().getSchema());
            if (this.hasReservedField(eventType, schemaAsJson, "metadata")) {
                throw new InvalidEventTypeException("\"metadata\" property is reserved");
            }
            this.validatePartitionKeys(eventType);
            SchemaLoader.load((JSONObject)schemaAsJson);
        }
        catch (JSONException e) {
            throw new InvalidEventTypeException("schema must be a valid json");
        }
        catch (SchemaException e) {
            throw new InvalidEventTypeException("schema must be a valid json-schema");
        }
    }

    private void assignTopic(EventType eventType) {
        eventType.setTopic(this.uuidGenerator.randomUUID().toString());
    }

    private boolean hasReservedField(EventType eventType, JSONObject schemaAsJson, String field) {
        return eventType.getCategory() == EventCategory.BUSINESS && schemaAsJson.optJSONObject("properties") != null && schemaAsJson.getJSONObject("properties").has(field);
    }
}

