/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class StreamParameters {
    public final int batchLimitEvents;
    private final Optional<Long> streamLimitEvents;
    public final long batchTimeoutMillis;
    public final Optional<Long> streamTimeoutMillis;
    private final Optional<Integer> batchKeepAliveIterations;
    public final int windowSizeMessages;
    public final long commitTimeoutMillis;

    private StreamParameters(int batchLimitEvents, @Nullable Long streamLimitEvents, long batchTimeoutMillis, @Nullable Long streamTimeoutMillis, @Nullable Integer batchKeepAliveIterations, int windowSizeMessages, long commitTimeoutMillis) {
        this.batchLimitEvents = batchLimitEvents;
        this.streamLimitEvents = Optional.ofNullable(streamLimitEvents);
        this.batchTimeoutMillis = batchTimeoutMillis;
        this.streamTimeoutMillis = Optional.ofNullable(streamTimeoutMillis);
        this.batchKeepAliveIterations = Optional.ofNullable(batchKeepAliveIterations);
        this.windowSizeMessages = windowSizeMessages;
        this.commitTimeoutMillis = commitTimeoutMillis;
    }

    public long getMessagesAllowedToSend(long limit, long sentSoFar) {
        return this.streamLimitEvents.map(v -> Math.max(0L, Math.min(limit, v - sentSoFar))).orElse(limit);
    }

    public boolean isStreamLimitReached(long commitedEvents) {
        return this.streamLimitEvents.map(v -> v <= commitedEvents).orElse(false);
    }

    public boolean isKeepAliveLimitReached(IntStream keepAlive) {
        return this.batchKeepAliveIterations.map(it -> keepAlive.allMatch(v -> v >= it)).orElse(false);
    }

    public static StreamParameters of(int batchLimitEvents, @Nullable Long streamLimitEvents, long batchTimeoutSeconds, @Nullable Long streamTimeoutSeconds, @Nullable Integer batchKeepAliveIterations, int windowSizeMessages, long commitTimeoutSeconds) {
        return new StreamParameters(batchLimitEvents, streamLimitEvents, TimeUnit.SECONDS.toMillis(batchTimeoutSeconds), Optional.ofNullable(streamTimeoutSeconds).map(TimeUnit.SECONDS::toMillis).orElse(null), batchKeepAliveIterations, windowSizeMessages, TimeUnit.SECONDS.toMillis(commitTimeoutSeconds));
    }
}

