/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.service.subscription.zk;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.zalando.nakadi.exceptions.ExceptionWrapper;
import org.zalando.nakadi.service.subscription.zk.ZKSubscription;

public abstract class ChangeListener
implements ZKSubscription,
Watcher {
    protected final CuratorFramework curatorFramework;
    protected final String key;
    private final Runnable listener;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final AtomicBoolean registered = new AtomicBoolean();

    protected ChangeListener(CuratorFramework curatorFramework, String key, Runnable listener) {
        this.curatorFramework = curatorFramework;
        this.key = key;
        this.listener = listener;
        this.refresh();
    }

    public void process(WatchedEvent event) {
        this.registered.set(false);
        if (!this.cancelled.get()) {
            this.listener.run();
        }
    }

    protected abstract void setInternal() throws Exception;

    @Override
    public void refresh() {
        if (!this.cancelled.get() && !this.registered.get()) {
            try {
                this.registered.set(true);
                this.setInternal();
            }
            catch (Exception e) {
                throw new ExceptionWrapper(e);
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled.set(true);
    }

    public static ChangeListener forChildren(CuratorFramework curatorFramework, String key, Runnable listener) {
        return new ChildrenListener(curatorFramework, key, listener);
    }

    public static ChangeListener forData(CuratorFramework curatorFramework, String key, Runnable listener) {
        return new ValueListener(curatorFramework, key, listener);
    }

    private static class ValueListener
    extends ChangeListener {
        public ValueListener(CuratorFramework curatorFramework, String key, Runnable listener) {
            super(curatorFramework, key, listener);
        }

        @Override
        protected void setInternal() throws Exception {
            ((BackgroundPathable)this.curatorFramework.getData().usingWatcher((Watcher)this)).forPath(this.key);
        }
    }

    private static class ChildrenListener
    extends ChangeListener {
        public ChildrenListener(CuratorFramework curatorFramework, String key, Runnable listener) {
            super(curatorFramework, key, listener);
        }

        @Override
        protected void setInternal() throws Exception {
            ((BackgroundPathable)this.curatorFramework.getChildren().usingWatcher((Watcher)this)).forPath(this.key);
        }
    }
}

