/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.validation;

import java.util.Objects;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.zalando.nakadi.domain.EventTypeOptions;

public final class EventTypeOptionsValidator
implements Validator {
    private final long minTopicRetentionMs;
    private final long maxTopicRetentionMs;

    public EventTypeOptionsValidator(long minTopicRetentionMs, long maxTopicRetentionMs) {
        this.minTopicRetentionMs = minTopicRetentionMs;
        this.maxTopicRetentionMs = maxTopicRetentionMs;
    }

    public boolean supports(Class<?> clazz) {
        return EventTypeOptions.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        EventTypeOptions options = (EventTypeOptions)target;
        this.checkRetentionTime(errors, options);
    }

    private void checkRetentionTime(Errors errors, EventTypeOptions options) {
        if (Objects.nonNull(options) && Objects.nonNull(options.getRetentionTime())) {
            Long retentionTime = options.getRetentionTime();
            if (retentionTime > this.maxTopicRetentionMs) {
                this.createError(errors, "can not be more than " + this.maxTopicRetentionMs);
            } else if (retentionTime < this.minTopicRetentionMs) {
                this.createError(errors, "can not be less than " + this.minTopicRetentionMs);
            }
        }
    }

    private void createError(Errors errors, String message) {
        errors.rejectValue("options.retentionTime", null, message);
    }
}

