/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.validation;

import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zalando.nakadi.domain.EventCategory;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.domain.ValidationStrategyConfiguration;
import org.zalando.nakadi.validation.EventTypeValidator;

public class EventValidation {
    public static final String DATA_CHANGE_WRAP_FIELD = "data";

    public static EventTypeValidator forType(EventType eventType) {
        EventTypeValidator etv = new EventTypeValidator(eventType);
        ValidationStrategyConfiguration vsc = new ValidationStrategyConfiguration();
        vsc.setStrategyName("schema-validation");
        etv.withConfiguration(vsc);
        if (eventType.getCategory() == EventCategory.BUSINESS || eventType.getCategory() == EventCategory.DATA) {
            ValidationStrategyConfiguration metadataConf = new ValidationStrategyConfiguration();
            metadataConf.setStrategyName("metadata-validation");
            etv.withConfiguration(metadataConf);
        }
        return etv;
    }

    public static JSONObject effectiveSchema(EventType eventType) throws JSONException {
        JSONObject schema = new JSONObject(eventType.getSchema().getSchema());
        switch (eventType.getCategory()) {
            case BUSINESS: {
                return EventValidation.addMetadata(schema, eventType);
            }
            case DATA: {
                return EventValidation.wrapSchemaInData(schema, eventType);
            }
        }
        return schema;
    }

    private static JSONObject wrapSchemaInData(JSONObject schema, EventType eventType) {
        JSONObject wrapper = new JSONObject();
        EventValidation.normalizeSchema(wrapper);
        EventValidation.addMetadata(wrapper, eventType);
        EventValidation.moveDefinitionsToRoot(wrapper, schema);
        JSONObject properties = wrapper.getJSONObject("properties");
        properties.put("data_type", (Object)new JSONObject().put("type", (Object)"string"));
        properties.put("data_op", (Object)new JSONObject().put("type", (Object)"string").put("enum", Arrays.asList("C", "U", "D", "S")));
        properties.put(DATA_CHANGE_WRAP_FIELD, (Object)schema);
        wrapper.put("additionalProperties", false);
        EventValidation.addToRequired(wrapper, new String[]{"data_type", "data_op", DATA_CHANGE_WRAP_FIELD});
        return wrapper;
    }

    private static void moveDefinitionsToRoot(JSONObject wrapper, JSONObject schema) {
        Object definitions = schema.remove("definitions");
        if (definitions != null) {
            wrapper.put("definitions", definitions);
        }
    }

    private static JSONObject addMetadata(JSONObject schema, EventType eventType) {
        EventValidation.normalizeSchema(schema);
        JSONObject metadata = new JSONObject();
        JSONObject metadataProperties = new JSONObject();
        JSONObject uuid = new JSONObject().put("type", (Object)"string").put("pattern", (Object)"^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$");
        JSONObject arrayOfUUIDs = new JSONObject().put("type", (Object)"array").put("items", (Object)uuid);
        JSONObject eventTypeString = new JSONObject().put("type", (Object)"string").put("enum", Arrays.asList(eventType.getName()));
        JSONObject string = new JSONObject().put("type", (Object)"string");
        JSONObject dateTime = new JSONObject().put("type", (Object)"string");
        metadataProperties.put("eid", (Object)uuid);
        metadataProperties.put("event_type", (Object)eventTypeString);
        metadataProperties.put("occurred_at", (Object)dateTime);
        metadataProperties.put("parent_eids", (Object)arrayOfUUIDs);
        metadataProperties.put("flow_id", (Object)string);
        metadataProperties.put("partition", (Object)string);
        metadata.put("type", (Object)"object");
        metadata.put("properties", (Object)metadataProperties);
        metadata.put("required", Arrays.asList("eid", "occurred_at"));
        metadata.put("additionalProperties", false);
        schema.getJSONObject("properties").put("metadata", (Object)metadata);
        EventValidation.addToRequired(schema, new String[]{"metadata"});
        return schema;
    }

    private static void addToRequired(JSONObject schema, String[] toBeRequired) {
        HashSet<String> required = new HashSet<String>(Arrays.asList(toBeRequired));
        JSONArray currentRequired = schema.getJSONArray("required");
        for (int i = 0; i < currentRequired.length(); ++i) {
            required.add(currentRequired.getString(i));
        }
        schema.put("required", required);
    }

    private static void normalizeSchema(JSONObject schema) {
        schema.put("type", (Object)"object");
        if (!schema.has("properties")) {
            schema.put("properties", (Object)new JSONObject());
        }
        if (!schema.has("required")) {
            schema.put("required", (Object)new JSONArray());
        }
    }
}

