/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.json.JSONObject;
import org.zalando.nakadi.validation.EventValidator;
import org.zalando.nakadi.validation.JSONSchemaValidator;
import org.zalando.nakadi.validation.QualifiedJSONSchemaValidator;
import org.zalando.nakadi.validation.ValidationError;

class QualifiedJSONSchemaValidationChain
implements EventValidator {
    private final List<QualifiedJSONSchemaValidator> qualifiedValidators;
    private final JSONSchemaValidator defaultSchemaValidator;

    public QualifiedJSONSchemaValidationChain(List<QualifiedJSONSchemaValidator> qualifiedValidators, JSONSchemaValidator defaultSchemaValidator) {
        this.qualifiedValidators = qualifiedValidators;
        this.defaultSchemaValidator = defaultSchemaValidator;
    }

    @Override
    public Optional<ValidationError> accepts(JSONObject event) {
        Predicate<QualifiedJSONSchemaValidator> matchingQualifier = it -> it.getQualifier().getMatch().equals(event.getString(it.getQualifier().getField()));
        EventValidator validator = this.qualifiedValidators.stream().filter(matchingQualifier).map(EventValidator.class::cast).findFirst().orElse(this.defaultSchemaValidator);
        return validator.accepts(event);
    }
}

