/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.validation;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.everit.json.schema.FormatValidator;

public class RFC3339DateTimeValidator
implements FormatValidator {
    private final String errorMessage = "must be a valid date-time";
    private final String dateTimeOffsetPattern = "^.*(Z|((\\+|-)\\d\\d:\\d\\d))$";
    private final Pattern pattern = Pattern.compile("^.*(Z|((\\+|-)\\d\\d:\\d\\d))$");
    private final Optional<String> error = Optional.of("must be a valid date-time");

    public Optional<String> validate(String dateTime) {
        try {
            OffsetDateTime.parse(dateTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            Matcher matcher = this.pattern.matcher(dateTime);
            if (matcher.matches()) {
                return Optional.empty();
            }
            return this.error;
        }
        catch (DateTimeParseException e) {
            return this.error;
        }
    }
}

