/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class StringSchema
extends Schema {
    private final Integer minLength;
    private final Integer maxLength;
    private final Pattern pattern;
    private final boolean requiresString;
    private final FormatValidator formatValidator;

    public static Builder builder() {
        return new Builder();
    }

    public StringSchema() {
        this(StringSchema.builder());
    }

    public StringSchema(Builder builder) {
        super(builder);
        this.minLength = builder.minLength;
        this.maxLength = builder.maxLength;
        this.requiresString = builder.requiresString;
        this.pattern = builder.pattern != null ? Pattern.compile(builder.pattern) : null;
        this.formatValidator = builder.formatValidator;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private List<ValidationException> testLength(String subject) {
        int actualLength = subject.length();
        ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
        if (this.minLength != null && actualLength < this.minLength) {
            rval.add(new ValidationException((Schema)this, "expected minLength: " + this.minLength + ", actual: " + actualLength));
        }
        if (this.maxLength != null && actualLength > this.maxLength) {
            rval.add(new ValidationException((Schema)this, "expected maxLength: " + this.maxLength + ", actual: " + actualLength));
        }
        return rval;
    }

    private List<ValidationException> testPattern(String subject) {
        if (this.pattern != null && !this.pattern.matcher(subject).find()) {
            return Arrays.asList(new ValidationException((Schema)this, String.format("string [%s] does not match pattern %s", subject, this.pattern.pattern())));
        }
        return Collections.emptyList();
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof String)) {
            if (this.requiresString) {
                throw new ValidationException(this, String.class, subject);
            }
        } else {
            String stringSubject = (String)subject;
            ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
            rval.addAll(this.testLength(stringSubject));
            rval.addAll(this.testPattern(stringSubject));
            this.formatValidator.validate(stringSubject).map(failure -> new ValidationException((Schema)this, (String)failure)).ifPresent(rval::add);
            ValidationException.throwFor(this, rval);
        }
    }

    public static class Builder
    extends Schema.Builder<StringSchema> {
        private Integer minLength;
        private Integer maxLength;
        private String pattern;
        private boolean requiresString = true;
        private FormatValidator formatValidator = FormatValidator.NONE;

        @Override
        public StringSchema build() {
            return new StringSchema(this);
        }

        public Builder formatValidator(FormatValidator formatValidator) {
            this.formatValidator = Objects.requireNonNull(formatValidator, "formatValidator cannot be null");
            return this;
        }

        public Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder requiresString(boolean requiresString) {
            this.requiresString = requiresString;
            return this;
        }
    }
}

