/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableMap;
import javax.ws.rs.core.Response;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.DefaultProblemMixIn;
import org.zalando.problem.Exceptional;
import org.zalando.problem.ExceptionalMixin;
import org.zalando.problem.MoreStatus;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemMixIn;
import org.zalando.problem.StatusTypeDeserializer;
import org.zalando.problem.StatusTypeSerializer;

public final class ProblemModule
extends SimpleModule {
    public ProblemModule() {
        this(Response.Status.class, MoreStatus.class);
    }

    @SafeVarargs
    public <E extends Enum> ProblemModule(Class<? extends E> ... types) throws IllegalArgumentException {
        super(ProblemModule.class.getSimpleName(), ProblemModule.getVersion());
        this.setMixInAnnotation(Exceptional.class, ExceptionalMixin.class);
        this.setMixInAnnotation(DefaultProblem.class, DefaultProblemMixIn.class);
        this.setMixInAnnotation(Problem.class, ProblemMixIn.class);
        this.addSerializer(Response.StatusType.class, new StatusTypeSerializer());
        this.addDeserializer(Response.StatusType.class, new StatusTypeDeserializer(this.buildIndex(types)));
    }

    private static Version getVersion() {
        return VersionUtil.mavenVersionFor((ClassLoader)ProblemModule.class.getClassLoader(), (String)"org.zalando", (String)"jackson-datatype-problem");
    }

    @SafeVarargs
    private final <E extends Enum> ImmutableMap<Integer, Response.StatusType> buildIndex(Class<? extends E> ... types) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Class<E> clazz : types) {
            for (Enum status : (Enum[])clazz.getEnumConstants()) {
                builder.put((Object)((Response.StatusType)status).getStatusCode(), (Object)status);
            }
        }
        return builder.build();
    }
}

