/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.validation.Validation;
import org.apache.catalina.mbeans.MBeanFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;

public class BackgroundPreinitializer
implements ApplicationListener<ApplicationStartedEvent> {
    public void onApplicationEvent(ApplicationStartedEvent event) {
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            this.submit(executor, new MessageConverterInitializer());
            this.submit(executor, new MBeanFactoryInitializer());
            this.submit(executor, new ValidationInitializer());
            executor.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void submit(ExecutorService executor, Runnable runnable) {
        executor.submit(new FailSafeRunnable(runnable));
    }

    private static class ValidationInitializer
    implements Runnable {
        private ValidationInitializer() {
        }

        @Override
        public void run() {
            Validation.byDefaultProvider().configure();
        }
    }

    private static class MBeanFactoryInitializer
    implements Runnable {
        private MBeanFactoryInitializer() {
        }

        @Override
        public void run() {
            new MBeanFactory();
        }
    }

    private static class MessageConverterInitializer
    implements Runnable {
        private MessageConverterInitializer() {
        }

        @Override
        public void run() {
            new AllEncompassingFormHttpMessageConverter();
        }
    }

    private static class FailSafeRunnable
    implements Runnable {
        private final Runnable delegate;

        FailSafeRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

