/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetailsSource;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.util.Assert;

public class OAuth2ClientAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    public OAuth2RestOperations restTemplate;
    private ResourceServerTokenServices tokenServices;
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new OAuth2AuthenticationDetailsSource();

    public void setTokenServices(ResourceServerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void setRestTemplate(OAuth2RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public OAuth2ClientAuthenticationProcessingFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
        this.setAuthenticationManager(new NoopAuthenticationManager());
        this.setAuthenticationDetailsSource(this.authenticationDetailsSource);
    }

    public void afterPropertiesSet() {
        Assert.state((this.restTemplate != null ? 1 : 0) != 0, (String)"Supply a rest-template");
        super.afterPropertiesSet();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        OAuth2AccessToken accessToken;
        try {
            accessToken = this.restTemplate.getAccessToken();
        }
        catch (OAuth2Exception e) {
            throw new BadCredentialsException("Could not obtain access token", (Throwable)e);
        }
        try {
            OAuth2Authentication result = this.tokenServices.loadAuthentication(accessToken.getValue());
            if (this.authenticationDetailsSource != null) {
                request.setAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_VALUE, (Object)accessToken.getValue());
                request.setAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_TYPE, (Object)accessToken.getTokenType());
                result.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            }
            return result;
        }
        catch (InvalidTokenException e) {
            throw new BadCredentialsException("Could not obtain user details from token", (Throwable)e);
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        super.successfulAuthentication(request, response, chain, authResult);
        this.restTemplate.getAccessToken();
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        if (failed instanceof AccessTokenRequiredException) {
            throw failed;
        }
        super.unsuccessfulAuthentication(request, response, failed);
    }

    private static class NoopAuthenticationManager
    implements AuthenticationManager {
        private NoopAuthenticationManager() {
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            throw new UnsupportedOperationException("No authentication should be done with this AuthenticationManager");
        }
    }
}

