/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.zalando.problem.Exceptional;
import org.zalando.problem.Problem;
import org.zalando.problem.spi.StackTraceProcessor;

@Immutable
public abstract class ThrowableProblem
extends RuntimeException
implements Problem,
Exceptional {
    private static final Joiner DELIMITER = Joiner.on((String)": ").skipNulls();

    public ThrowableProblem() {
        this((ThrowableProblem)null);
    }

    public ThrowableProblem(@Nullable ThrowableProblem cause) {
        super(cause);
        Collection<StackTraceElement> stackTrace = StackTraceProcessor.COMPOUND.process(Arrays.asList(this.getStackTrace()));
        this.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
    }

    @Override
    public String getMessage() {
        return DELIMITER.join((Object)this.getTitle(), this.getDetail().orElse(null), new Object[0]);
    }

    @Override
    public ThrowableProblem getCause() {
        return (ThrowableProblem)super.getCause();
    }

    @Override
    public String toString() {
        return Problem.toString(this);
    }
}

