/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.config;

import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.zalando.nakadi.config.SecuritySettings;

@EnableResourceServer
@Configuration
public class SecurityConfiguration
extends ResourceServerConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityConfiguration.class);
    @Autowired
    private SecuritySettings settings;
    @Autowired
    private ResourceServerTokenServices tokenServices;
    @Value(value="${nakadi.oauth2.scopes.uid}")
    private String uidScope;
    @Value(value="${nakadi.oauth2.scopes.nakadiAdmin}")
    private String nakadiAdminScope;
    @Value(value="${nakadi.oauth2.scopes.eventTypeWrite}")
    private String eventTypeWriteScope;
    @Value(value="${nakadi.oauth2.scopes.eventStreamRead}")
    private String eventStreamReadScope;
    @Value(value="${nakadi.oauth2.scopes.eventStreamWrite}")
    private String eventStreamWriteScope;

    public void configure(HttpSecurity http) throws Exception {
        LOG.info("Authentication mode: " + (Object)((Object)this.settings.getAuthMode()));
        if (this.settings.getAuthMode() == SecuritySettings.AuthMode.FULL) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/event-types/*/partitions/**"})).access(SecurityConfiguration.hasScope(this.eventStreamReadScope)).antMatchers(HttpMethod.GET, new String[]{"/event-types/*/events/**"})).access(SecurityConfiguration.hasScope(this.eventStreamReadScope)).antMatchers(HttpMethod.GET, new String[]{"/subscriptions/*/events/**"})).access(SecurityConfiguration.hasScope(this.eventStreamReadScope)).antMatchers(HttpMethod.PUT, new String[]{"/subscriptions/*/cursors/**"})).access(SecurityConfiguration.hasScope(this.eventStreamReadScope)).antMatchers(HttpMethod.POST, new String[]{"/event-types/*/events/**"})).access(SecurityConfiguration.hasScope(this.eventStreamWriteScope)).antMatchers(HttpMethod.DELETE, new String[]{"/event-types/*/**"})).access(SecurityConfiguration.hasScope(this.nakadiAdminScope)).antMatchers(HttpMethod.POST, new String[]{"/event-types/**"})).access(SecurityConfiguration.hasScope(this.eventTypeWriteScope)).antMatchers(HttpMethod.PUT, new String[]{"/event-types/**"})).access(SecurityConfiguration.hasScope(this.eventTypeWriteScope)).antMatchers(HttpMethod.POST, new String[]{"/subscriptions/**"})).access(SecurityConfiguration.hasScope(this.eventStreamReadScope)).antMatchers(HttpMethod.GET, new String[]{"/health/**"})).permitAll().anyRequest()).access(SecurityConfiguration.hasScope(this.uidScope));
        } else if (this.settings.getAuthMode() == SecuritySettings.AuthMode.BASIC) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/health/**"})).permitAll().anyRequest()).access(SecurityConfiguration.hasScope(this.uidScope));
        } else {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).permitAll();
        }
    }

    public static String hasScope(String scope) {
        return MessageFormat.format("#oauth2.hasScope(''{0}'')", scope);
    }

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.tokenServices(this.tokenServices);
    }
}

