/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.config;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.TimeoutCallableProcessingInterceptor;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.zalando.nakadi.metrics.MonitoringRequestFilter;
import org.zalando.nakadi.security.ClientResolver;
import org.zalando.nakadi.util.FlowIdRequestFilter;
import org.zalando.nakadi.util.GzipBodyRequestFilter;

@Configuration
public class WebConfig
extends WebMvcConfigurationSupport {
    @Value(value="${nakadi.stream.timeoutMs}")
    private long nakadiStreamTimeout;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ClientResolver clientResolver;

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        configurer.setDefaultTimeout(this.nakadiStreamTimeout);
        configurer.registerCallableInterceptors(new CallableProcessingInterceptor[]{this.timeoutInterceptor()});
    }

    @Bean
    public TimeoutCallableProcessingInterceptor timeoutInterceptor() {
        return new TimeoutCallableProcessingInterceptor();
    }

    @Bean
    public FilterRegistrationBean flowIdRequestFilter() {
        return this.createFilterRegistrationBean(new FlowIdRequestFilter(), -2147483647);
    }

    @Bean
    public FilterRegistrationBean gzipBodyRequestFilter(ObjectMapper mapper) {
        return this.createFilterRegistrationBean(new GzipBodyRequestFilter(mapper), -2147483646);
    }

    @Bean
    public FilterRegistrationBean monitoringRequestFilter(MetricRegistry metricRegistry) {
        return this.createFilterRegistrationBean(new MonitoringRequestFilter(metricRegistry), Integer.MIN_VALUE);
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(this.objectMapper);
        return converter;
    }

    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter();
        stringConverter.setWriteAcceptCharset(false);
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)stringConverter);
        converters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)this.mappingJackson2HttpMessageConverter());
        super.configureMessageConverters(converters);
    }

    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(this.clientResolver);
    }

    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        RequestMappingHandlerMapping handlerMapping = super.requestMappingHandlerMapping();
        handlerMapping.setUseSuffixPatternMatch(false);
        return handlerMapping;
    }

    private FilterRegistrationBean createFilterRegistrationBean(Filter filter, int order) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter(filter);
        filterRegistrationBean.setOrder(order);
        return filterRegistrationBean;
    }
}

