/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.controller;

import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.nakadi.domain.Cursor;
import org.zalando.nakadi.exceptions.InvalidCursorException;
import org.zalando.nakadi.exceptions.NakadiException;
import org.zalando.nakadi.service.CursorsService;
import org.zalando.nakadi.util.FeatureToggleService;
import org.zalando.problem.MoreStatus;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.Responses;

@RestController
public class CursorsController {
    private final CursorsService cursorsService;
    private final FeatureToggleService featureToggleService;

    @Autowired
    public CursorsController(CursorsService cursorsService, FeatureToggleService featureToggleService) {
        this.cursorsService = cursorsService;
        this.featureToggleService = featureToggleService;
    }

    @RequestMapping(path={"/subscriptions/{subscriptionId}/cursors"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCursors(@PathVariable(value="subscriptionId") String subscriptionId, NativeWebRequest request) {
        if (!this.featureToggleService.isFeatureEnabled(FeatureToggleService.Feature.HIGH_LEVEL_API)) {
            return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
        }
        try {
            List<Cursor> cursors = this.cursorsService.getSubscriptionCursors(subscriptionId);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(cursors);
        }
        catch (NakadiException e) {
            return Responses.create((Problem)e.asProblem(), (NativeWebRequest)request);
        }
    }

    @RequestMapping(value={"/subscriptions/{subscriptionId}/cursors"}, method={RequestMethod.PUT})
    public ResponseEntity<?> commitCursors(@PathVariable(value="subscriptionId") String subscriptionId, @RequestBody List<Cursor> cursors, NativeWebRequest request) {
        if (!this.featureToggleService.isFeatureEnabled(FeatureToggleService.Feature.HIGH_LEVEL_API)) {
            return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
        }
        try {
            boolean allCommitted = this.cursorsService.commitCursors(subscriptionId, cursors);
            return allCommitted ? ResponseEntity.ok().build() : ResponseEntity.noContent().build();
        }
        catch (NakadiException e) {
            return Responses.create((Problem)e.asProblem(), (NativeWebRequest)request);
        }
        catch (InvalidCursorException e) {
            return Responses.create((Problem)Problem.valueOf((Response.StatusType)MoreStatus.UNPROCESSABLE_ENTITY, (String)e.getMessage()), (NativeWebRequest)request);
        }
    }
}

