/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.controller;

import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.nakadi.domain.EventPublishResult;
import org.zalando.nakadi.exceptions.NakadiException;
import org.zalando.nakadi.exceptions.NoSuchEventTypeException;
import org.zalando.nakadi.metrics.EventTypeMetricRegistry;
import org.zalando.nakadi.metrics.EventTypeMetrics;
import org.zalando.nakadi.service.EventPublisher;
import org.zalando.problem.Problem;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.Responses;

@RestController
public class EventPublishingController {
    private static final Logger LOG = LoggerFactory.getLogger(EventPublishingController.class);
    private final EventPublisher publisher;
    private final EventTypeMetricRegistry eventTypeMetricRegistry;

    @Autowired
    public EventPublishingController(EventPublisher publisher, EventTypeMetricRegistry eventTypeMetricRegistry) {
        this.publisher = publisher;
        this.eventTypeMetricRegistry = eventTypeMetricRegistry;
    }

    @RequestMapping(value={"/event-types/{eventTypeName}/events"}, method={RequestMethod.POST})
    public ResponseEntity postEvent(@PathVariable String eventTypeName, @RequestBody String eventsAsString, NativeWebRequest nativeWebRequest) {
        LOG.trace("Received event {} for event type {}", (Object)eventsAsString, (Object)eventTypeName);
        EventTypeMetrics eventTypeMetrics = this.eventTypeMetricRegistry.metricsFor(eventTypeName);
        try {
            ResponseEntity response = this.postEventInternal(eventTypeName, eventsAsString, nativeWebRequest, eventTypeMetrics);
            eventTypeMetrics.incrementResponseCount(response.getStatusCode().value());
            return response;
        }
        catch (RuntimeException ex) {
            eventTypeMetrics.incrementResponseCount(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseEntity postEventInternal(String eventTypeName, String eventsAsString, NativeWebRequest nativeWebRequest, EventTypeMetrics eventTypeMetrics) {
        long startingNanos = System.nanoTime();
        try {
            JSONArray eventsAsJsonObjects = new JSONArray(eventsAsString);
            int eventCount = eventsAsJsonObjects.length();
            eventTypeMetrics.reportSizing(eventCount, eventsAsString.length());
            ResponseEntity responseEntity = this.response(this.publisher.publish(eventsAsJsonObjects, eventTypeName));
            return responseEntity;
        }
        catch (JSONException e) {
            LOG.debug("Problem parsing event", (Throwable)e);
            ResponseEntity responseEntity = this.processJSONException(e, nativeWebRequest);
            return responseEntity;
        }
        catch (NoSuchEventTypeException e) {
            LOG.debug("Event type not found.", (Throwable)e);
            ResponseEntity responseEntity = Responses.create((Problem)e.asProblem(), (NativeWebRequest)nativeWebRequest);
            return responseEntity;
        }
        catch (NakadiException e) {
            LOG.debug("Failed to publish batch", (Throwable)e);
            ResponseEntity responseEntity = Responses.create((Problem)e.asProblem(), (NativeWebRequest)nativeWebRequest);
            return responseEntity;
        }
        finally {
            eventTypeMetrics.updateTiming(startingNanos, System.nanoTime());
        }
    }

    private ResponseEntity processJSONException(JSONException e, NativeWebRequest nativeWebRequest) {
        if (e.getCause() == null) {
            return Responses.create((Problem)this.createProblem(e), (NativeWebRequest)nativeWebRequest);
        }
        return Responses.create((Problem)Problem.valueOf((Response.StatusType)Response.Status.BAD_REQUEST), (NativeWebRequest)nativeWebRequest);
    }

    private ThrowableProblem createProblem(JSONException e) {
        return Problem.valueOf((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
    }

    private ResponseEntity response(EventPublishResult result) {
        switch (result.getStatus()) {
            case SUBMITTED: {
                return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
            }
            case ABORTED: {
                return ResponseEntity.status((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY).body(result.getResponses());
            }
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.MULTI_STATUS).body(result.getResponses());
    }
}

