/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.controller;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import org.zalando.nakadi.domain.Cursor;
import org.zalando.nakadi.domain.EventType;
import org.zalando.nakadi.exceptions.InvalidCursorException;
import org.zalando.nakadi.exceptions.NakadiException;
import org.zalando.nakadi.exceptions.NoSuchEventTypeException;
import org.zalando.nakadi.metrics.MetricUtils;
import org.zalando.nakadi.repository.EventConsumer;
import org.zalando.nakadi.repository.EventTypeRepository;
import org.zalando.nakadi.repository.TopicRepository;
import org.zalando.nakadi.service.ClosedConnectionsCrutch;
import org.zalando.nakadi.service.EventStream;
import org.zalando.nakadi.service.EventStreamConfig;
import org.zalando.nakadi.service.EventStreamFactory;
import org.zalando.problem.Problem;

@RestController
public class EventStreamController {
    private static final Logger LOG = LoggerFactory.getLogger(EventStreamController.class);
    public static final String CONSUMERS_COUNT_METRIC_NAME = "consumers";
    private final EventTypeRepository eventTypeRepository;
    private final TopicRepository topicRepository;
    private final ObjectMapper jsonMapper;
    private final EventStreamFactory eventStreamFactory;
    private final MetricRegistry metricRegistry;
    private final ClosedConnectionsCrutch closedConnectionsCrutch;

    @Autowired
    public EventStreamController(EventTypeRepository eventTypeRepository, TopicRepository topicRepository, ObjectMapper jsonMapper, EventStreamFactory eventStreamFactory, MetricRegistry metricRegistry, ClosedConnectionsCrutch closedConnectionsCrutch) {
        this.eventTypeRepository = eventTypeRepository;
        this.topicRepository = topicRepository;
        this.jsonMapper = jsonMapper;
        this.eventStreamFactory = eventStreamFactory;
        this.metricRegistry = metricRegistry;
        this.closedConnectionsCrutch = closedConnectionsCrutch;
    }

    @RequestMapping(value={"/event-types/{name}/events"}, method={RequestMethod.GET})
    public StreamingResponseBody streamEvents(@PathVariable(value="name") String eventTypeName, @Nullable @RequestParam(value="batch_limit", required=false) Integer batchLimit, @Nullable @RequestParam(value="stream_limit", required=false) Integer streamLimit, @Nullable @RequestParam(value="batch_flush_timeout", required=false) Integer batchTimeout, @Nullable @RequestParam(value="stream_timeout", required=false) Integer streamTimeout, @Nullable @RequestParam(value="stream_keep_alive_limit", required=false) Integer streamKeepAliveLimit, @Nullable @RequestHeader(name="X-nakadi-cursors", required=false) String cursorsStr, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return outputStream -> {
            AtomicBoolean connectionReady = this.closedConnectionsCrutch.listenForConnectionClose(request);
            Counter consumerCounter = null;
            Closeable eventConsumer = null;
            try {
                consumerCounter = this.metricRegistry.counter(MetricUtils.metricNameFor(eventTypeName, CONSUMERS_COUNT_METRIC_NAME));
                consumerCounter.inc();
                EventType eventType = this.eventTypeRepository.findByName(eventTypeName);
                String topic = eventType.getTopic();
                if (!this.topicRepository.topicExists(topic)) {
                    this.writeProblemResponse(response, outputStream, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "topic is absent in kafka");
                    return;
                }
                EventStreamConfig.Builder builder = EventStreamConfig.builder().withTopic(topic).withBatchLimit(batchLimit).withStreamLimit(streamLimit).withBatchTimeout(batchTimeout).withStreamTimeout(streamTimeout).withStreamKeepAliveLimit(streamKeepAliveLimit);
                List cursors = null;
                if (cursorsStr != null) {
                    try {
                        cursors = (List)this.jsonMapper.readValue(cursorsStr, (TypeReference)new TypeReference<ArrayList<Cursor>>(){});
                    }
                    catch (IOException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Incorrect syntax of X-nakadi-cursors header: " + cursorsStr + ". Respond with BAD_REQUEST.", (Throwable)e);
                        }
                        this.writeProblemResponse(response, outputStream, (Response.StatusType)Response.Status.BAD_REQUEST, "incorrect syntax of X-nakadi-cursors header");
                        connectionReady.set(false);
                        if (consumerCounter != null) {
                            consumerCounter.dec();
                        }
                        if (eventConsumer != null) {
                            eventConsumer.close();
                        }
                        try {
                            outputStream.flush();
                        }
                        finally {
                            outputStream.close();
                        }
                        return;
                    }
                }
                if (cursors == null) {
                    cursors = this.topicRepository.listPartitions(topic).stream().map(pInfo -> new Cursor(pInfo.getPartitionId(), pInfo.getNewestAvailableOffset())).collect(Collectors.toList());
                }
                eventConsumer = this.topicRepository.createEventConsumer(topic, cursors);
                Map<String, String> streamCursors = cursors.stream().collect(Collectors.toMap(Cursor::getPartition, Cursor::getOffset));
                EventStreamConfig streamConfig = builder.withCursors(streamCursors).build();
                response.setStatus(HttpStatus.OK.value());
                response.setContentType("application/x-json-stream");
                EventStream eventStream = this.eventStreamFactory.createEventStream((EventConsumer)eventConsumer, outputStream, streamConfig);
                outputStream.flush();
                eventStream.streamEvents(connectionReady);
            }
            catch (NoSuchEventTypeException e) {
                this.writeProblemResponse(response, outputStream, (Response.StatusType)Response.Status.NOT_FOUND, "topic not found");
            }
            catch (NakadiException e) {
                LOG.error("Error while trying to stream events. Respond with SERVICE_UNAVAILABLE.", (Throwable)e);
                this.writeProblemResponse(response, outputStream, e.asProblem());
            }
            catch (InvalidCursorException e) {
                this.writeProblemResponse(response, outputStream, (Response.StatusType)Response.Status.PRECONDITION_FAILED, e.getMessage());
            }
            catch (Exception e) {
                LOG.error("Error while trying to stream events. Respond with INTERNAL_SERVER_ERROR.", (Throwable)e);
                this.writeProblemResponse(response, outputStream, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
            }
            finally {
                connectionReady.set(false);
                if (consumerCounter != null) {
                    consumerCounter.dec();
                }
                if (eventConsumer != null) {
                    eventConsumer.close();
                }
                try {
                    outputStream.flush();
                }
                finally {
                    outputStream.close();
                }
            }
        };
    }

    private void writeProblemResponse(HttpServletResponse response, OutputStream outputStream, Response.StatusType statusCode, String message) throws IOException {
        this.writeProblemResponse(response, outputStream, (Problem)Problem.valueOf((Response.StatusType)statusCode, (String)message));
    }

    private void writeProblemResponse(HttpServletResponse response, OutputStream outputStream, Problem problem) throws IOException {
        response.setStatus(problem.getStatus().getStatusCode());
        response.setContentType("application/problem+json");
        this.jsonMapper.writer().writeValue(outputStream, (Object)problem);
    }
}

