/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.controller;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.nakadi.domain.Subscription;
import org.zalando.nakadi.domain.SubscriptionBase;
import org.zalando.nakadi.exceptions.DuplicatedSubscriptionException;
import org.zalando.nakadi.exceptions.InternalNakadiException;
import org.zalando.nakadi.exceptions.NakadiException;
import org.zalando.nakadi.exceptions.NoSuchEventTypeException;
import org.zalando.nakadi.exceptions.NoSuchSubscriptionException;
import org.zalando.nakadi.problem.ValidationProblem;
import org.zalando.nakadi.repository.EventTypeRepository;
import org.zalando.nakadi.repository.db.SubscriptionDbRepository;
import org.zalando.nakadi.util.FeatureToggleService;
import org.zalando.problem.MoreStatus;
import org.zalando.problem.Problem;
import org.zalando.problem.spring.web.advice.Responses;

@RestController
@RequestMapping(value={"/subscriptions"})
public class SubscriptionController {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionController.class);
    private final SubscriptionDbRepository subscriptionRepository;
    private final EventTypeRepository eventTypeRepository;
    private final FeatureToggleService featureToggleService;

    @Autowired
    public SubscriptionController(SubscriptionDbRepository subscriptionRepository, EventTypeRepository eventTypeRepository, FeatureToggleService featureToggleService) {
        this.subscriptionRepository = subscriptionRepository;
        this.eventTypeRepository = eventTypeRepository;
        this.featureToggleService = featureToggleService;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<?> createOrGetSubscription(@Valid @RequestBody SubscriptionBase subscriptionBase, Errors errors, NativeWebRequest request) {
        if (!this.featureToggleService.isFeatureEnabled(FeatureToggleService.Feature.HIGH_LEVEL_API)) {
            return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
        }
        if (errors.hasErrors()) {
            return Responses.create((Problem)new ValidationProblem(errors), (NativeWebRequest)request);
        }
        try {
            return this.createSubscription(subscriptionBase, request);
        }
        catch (DuplicatedSubscriptionException e) {
            try {
                return new ResponseEntity((Object)this.getExistingSubscription(subscriptionBase), HttpStatus.OK);
            }
            catch (NakadiException ex) {
                LOG.error("Error occurred during fetching existing subscription", (Throwable)ex);
                return Responses.create((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (String)ex.getProblemMessage(), (NativeWebRequest)request);
            }
        }
        catch (InternalNakadiException e) {
            LOG.error("Error occurred during subscription creation", (Throwable)e);
            return Responses.create((Problem)e.asProblem(), (NativeWebRequest)request);
        }
    }

    private ResponseEntity<?> createSubscription(SubscriptionBase subscriptionBase, NativeWebRequest request) throws InternalNakadiException, DuplicatedSubscriptionException {
        List<String> noneExistingEventTypes = this.checkExistingEventTypes(subscriptionBase);
        if (!noneExistingEventTypes.isEmpty()) {
            String errorMessage = this.createErrorMessage(noneExistingEventTypes);
            LOG.debug(errorMessage);
            return Responses.create((Response.StatusType)MoreStatus.UNPROCESSABLE_ENTITY, (String)errorMessage, (NativeWebRequest)request);
        }
        Subscription subscription = this.subscriptionRepository.createSubscription(subscriptionBase);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)subscription);
    }

    private List<String> checkExistingEventTypes(SubscriptionBase subscriptionBase) throws InternalNakadiException {
        ArrayList noneExistingEventTypes = Lists.newArrayList();
        for (String etName : subscriptionBase.getEventTypes()) {
            try {
                this.eventTypeRepository.findByName(etName);
            }
            catch (NoSuchEventTypeException e) {
                noneExistingEventTypes.add(etName);
            }
        }
        return noneExistingEventTypes;
    }

    private String createErrorMessage(List<String> noneExistingEventTypes) {
        return "Failed to create subscription, event type(s) not found: '" + StringUtils.join(noneExistingEventTypes, (String)"','") + "'";
    }

    private Subscription getExistingSubscription(SubscriptionBase subscriptionBase) throws NoSuchSubscriptionException, InternalNakadiException {
        return this.subscriptionRepository.getSubscription(subscriptionBase.getOwningApplication(), subscriptionBase.getEventTypes(), subscriptionBase.getConsumerGroup());
    }
}

