/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.zalando.nakadi.controller.EventStreamController;

@RestController
@RequestMapping(value={"/version"}, produces={"application/json"})
@Profile(value={"!test"})
public class VersionController {
    private static final String SCM_SOURCE_FILE = "/scm-source.json";
    private final VersionInfo versionInfo;
    private static final Logger LOG = LoggerFactory.getLogger(EventStreamController.class);

    @Autowired
    public VersionController(ObjectMapper objectMapper) {
        this.versionInfo = new VersionInfo(VersionController.loadScmSource(objectMapper));
    }

    @RequestMapping(method={RequestMethod.GET})
    public VersionInfo getVersion() {
        return this.versionInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ScmSource loadScmSource(ObjectMapper objectMapper) {
        try (FileInputStream in = new FileInputStream(SCM_SOURCE_FILE);){
            ScmSource scmSource = (ScmSource)objectMapper.readValue((InputStream)in, ScmSource.class);
            return scmSource;
        }
        catch (IOException ex) {
            LOG.warn("Failed to read scm-source.json file from /scm-source.json", (Throwable)ex);
            return null;
        }
    }

    public static class VersionInfo {
        private final ScmSource scmSource;

        public VersionInfo(ScmSource scmSource) {
            this.scmSource = scmSource;
        }

        public ScmSource getScmSource() {
            return this.scmSource;
        }
    }

    private static class ScmSource {
        private String author;
        private String revision;
        private String status;
        private String url;

        private ScmSource() {
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

