/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.exceptions;

import java.util.function.Consumer;
import java.util.function.Function;
import org.zalando.nakadi.exceptions.ConsumerWithException;
import org.zalando.nakadi.exceptions.FunctionWithException;

public class ExceptionWrapper
extends RuntimeException {
    private final Exception wrapped;

    public ExceptionWrapper(Exception wrapped) {
        super(wrapped);
        this.wrapped = wrapped;
    }

    public Exception getWrapped() {
        return this.wrapped;
    }

    public static <T> Consumer<T> wrapConsumer(ConsumerWithException<T> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception e) {
                throw new ExceptionWrapper(e);
            }
        };
    }

    public static <T, R> Function<T, R> wrapFunction(FunctionWithException<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception e) {
                throw new ExceptionWrapper(e);
            }
        };
    }
}

