/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.nakadi.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.zalando.nakadi.metrics.EventTypeMetrics;

@Component
public class EventTypeMetricRegistry {
    private final ConcurrentMap<String, EventTypeMetrics> metricsPerEventType = new ConcurrentHashMap<String, EventTypeMetrics>();
    private final MetricRegistry metricRegistry;

    @Autowired
    public EventTypeMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public EventTypeMetrics metricsFor(String eventTypeName) {
        return this.metricsPerEventType.computeIfAbsent(eventTypeName, key -> new EventTypeMetrics(eventTypeName, this.metricRegistry));
    }
}

